/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.inventory;

import com.fluentcommerce.model.attribute.Attribute;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@Builder(toBuilder = true)
@AllArgsConstructor
public class VirtualPosition {

    private String id;
    private String ref;
    private Date createdOn;
    private Date updatedOn;
    private String type;
    private String status;
    private Integer quantity;
    private List<Attribute> attributes;
    private String productRef;
    private String groupRef;

}
