/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.criterion.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Represents a front-end select component option
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({})
public @interface SourcingCriterionParamSelectComponentOption {
    /**
     * @return label for the option (displayed to user)
     */
    String label();

    /**
     * @return value for the option (stored in configuration)
     */
    String value();
}
