/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.criterion.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates a parameter that should be preserved in the setting configuration of the Sourcing Criterion
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD})
public @interface SourcingCriterionParam {
    /**
     * @return name of the parameter
     */
    String name();

    /**
     * @return front-end component to use for the parameter
     */
    String component();

    /**
     * @return whether the exact search is enabled for the front-end component
     */
    boolean exactSearch() default false;

    /**
     * @return whether the parameter is mandatory
     */
    boolean mandatory() default true;

    /**
     * @return param type for the front-end component
     */
    String type() default "";

    /**
     * @return options for the front-end select component
     */
    SourcingCriterionParamSelectComponentOption[] selectComponentOptions() default {};
}
