/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fluentcommerce.util.sourcing.SourcingUtils;
import com.fluentcommerce.util.sourcing.context.SourcingContext;
import com.fluentcommerce.util.sourcing.context.model.Location;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;

import java.util.Optional;

@SourcingCriterionInfo(name = "locationExclusion",
        type = "fc.sourcing.criterion.locationExclusion",
        tags = {"ATS-agnostic"})
public class RejectedLocationExclusionCriterion extends BaseSourcingCriterion {

    @Override
    protected float execute(final SourcingCriteriaUtils.CriterionContext criterionContext) {
        final String locationRef = Optional.ofNullable(criterionContext.getLap())
                .map(SourcingUtils.LocationAndPositions::getLocation)
                .map(Location::getRef)
                .orElse(null);
        if (locationRef == null) {
            return 0;
        }

        return Optional.ofNullable(criterionContext.getSourcingContext())
                .map(SourcingContext::getFulfilments)
                .map(fulfilments -> fulfilments.stream()
                        .filter(fulfilment -> fulfilment.getFromLocation().getRef().equals(locationRef))
                        .anyMatch(fulfilment -> fulfilment.getItems().stream()
                                .anyMatch(fulfilmentItem -> fulfilmentItem.getRejectedQuantity() > 0)))
                .orElse(false) ? -1f : 1f;
    }

}
