/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fluentcommerce.util.sourcing.context.model.OrderItem;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;

import java.util.List;
import java.util.Optional;

@SourcingCriterionInfo(name = "orderValue",
        type = "fc.sourcing.criterion.orderValue",
        tags = {"ATS-dependent"})
public class OrderValueCriterion extends BaseSourcingCriterion {

    @Override
    protected float execute(final SourcingCriteriaUtils.CriterionContext criterionContext) {
        if (criterionContext.getLap().getQuantities() == null) {
            return 0;
        }

        final List<OrderItem> items = criterionContext.getSourcingContext().getUnfulfilledItems();

        float total = 0;
        float filled = 0;

        for (int i = 0; i < items.size(); i++) {
            final OrderItem item = items.get(i);
            final double itemValue = Optional.ofNullable(item.getPaidPrice()).orElse(0d) + Optional.ofNullable(item.getTaxPrice()).orElse(0d);
            double requested = item.getQuantity() * itemValue;
            total += (float) requested;
            filled += (float) Math.min(requested, criterionContext.getLap().getQuantities()[i] * itemValue);
        }
        if (total == 0) {
            return 0;
        }

        return filled / total;
    }

}