/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fluentcommerce.util.sourcing.context.model.Location;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionParam;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

import static com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaUtils.getStrings;

@SourcingCriterionInfo(name = "networkPriority",
        type = "fc.sourcing.criterion.networkPriority",
        tags = {"ATS-agnostic"})
public class NetworkPriorityCriterion extends BaseSourcingCriterion {

    @SourcingCriterionParam(name = "value", component = "fc.field.multistring", exactSearch = true)
    private List<String> bands;

    @Override
    public void parseParams(final JsonNode params) {
        bands = getStrings(params, "value");
    }

    @Override
    protected float execute(final SourcingCriteriaUtils.CriterionContext criterionContext) {
        final Set<String> networks = Optional.ofNullable(criterionContext.getLap().getLocation())
                .map(Location::getNetworks)
                .map(HashSet::new)
                .orElse(null);
        if (networks == null) {
            return 0;
        }

        for (int i = 0; i < bands.size(); i++) {
            if (networks.contains(bands.get(i))) {
                return (bands.size() - i);
            }
        }
        return 0;
    }

}
