/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionParam;

import java.util.HashSet;
import java.util.Set;

import static com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaUtils.getStrings;

@SourcingCriterionInfo(name = "locationTypeExclusion",
        type = "fc.sourcing.criterion.locationTypeExclusion",
        tags = {"Exclusion", "ATS-agnostic"})
public class LocationTypeExclusionCriterion extends BaseSourcingCriterion {

    @SourcingCriterionParam(name = "value", component = "fc.field.multistring", exactSearch = true)
    private Set<String> bands;

    @Override
    public void parseParams(final JsonNode params) {
        bands = new HashSet<>(getStrings(params, "value"));
    }

    @Override
    protected float execute(final SourcingCriteriaUtils.CriterionContext criterionContext) {
        return bands.contains(criterionContext.getLap().getLocation().getType())
                ? -1f : 1f;
    }
}
