/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;

import java.util.Optional;

@SourcingCriterionInfo(name = "locationDailyCapacity",
        type = "fc.sourcing.criterion.locationDailyCapacity",
        tags = {"ATS-agnostic"})
public class LocationDailyCapacityCriterion extends BaseSourcingCriterion {
    @Override
    protected float execute(final SourcingCriteriaUtils.CriterionContext criterionContext) {
        return Optional.ofNullable(JsonUtils.getPath(
                        JsonUtils.objectToNode(criterionContext.getLap().getLocation()),
                        "attributes.byName.DAILY_MAX_ORDER_CAPACITY"))
                .filter(JsonNode::isNumber)
                .map(JsonNode::asDouble)
                .map(Double::floatValue)
                .orElse(1f);
    }
}
