/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fluentcommerce.util.sourcing.context.model.OrderItem;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;

import java.util.List;

@SourcingCriterionInfo(name = "inventoryAvailability",
        type = "fc.sourcing.criterion.inventoryAvailability",
        tags = {"ATS-dependent"})
public class InventoryAvailabilityCriterion extends BaseSourcingCriterion {

    @Override
    protected float execute(final SourcingCriteriaUtils.CriterionContext criterionContext) {
        if (criterionContext.getLap().getQuantities() == null) {
            return 0;
        }

        final List<OrderItem> items = criterionContext.getSourcingContext().getUnfulfilledItems();

        int total = 0;
        int filled = 0;

        for (int i = 0; i < items.size(); i++) {
            int requested = items.get(i).getQuantity();
            total += requested;
            filled += criterionContext.getLap().getQuantities()[i];
        }
        if (total == 0) {
            return 1f;
        }
        return ((float) filled) / total;
    }

}
