/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.context.model;

import com.fluentretail.api.model.attribute.Attribute;
import com.fluentretail.api.model.sku.Price;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@Builder
@AllArgsConstructor
public class Product {

    private String id;
    private Date createdOn;
    private Date updatedOn;
    private String ref;
    private String type;
    private String status;
    private String name;
    private String summary;

    private List<Price> prices;
    private Tax tax;
    private List<Category> categories;
    private List<Attribute> attributes;
    private String catalogueRef;

    @Data
    @Builder
    @AllArgsConstructor
    public static class Tax {
        private String country;
        private String group;
        private String tariff;
    }

    @Data
    @Builder
    @AllArgsConstructor
    public static class Category {
        private String id;
        private Date createdOn;
        private Date updatedOn;
        private String ref;
        private String type;
        private String status;
        private String name;
        private String summary;
        private List<Attribute> attributes;
    }
}
