/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.context.model;

import com.fluentretail.api.model.attribute.Attribute;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@Builder(toBuilder = true)
@AllArgsConstructor
public class FulfilmentChoice {

    private String id;
    private String ref;
    private String type;
    private String status;
    private Date createdOn;
    private Date updatedOn;
    private String currency;
    private String deliveryFirstName;
    private String deliveryLastName;
    private String deliveryContact;
    private String deliveryEmail;
    private Date deliverAfter;
    private Date deliverBefore;
    private Date dispatchOn;
    private String deliveryInstruction;
    private String deliveryType;
    private Double fulfilmentPrice;
    private Double fulfilmentTaxPrice;
    private String fulfilmentType;
    private String pickupLocationRef;
    private List<Attribute> attributes;
    private Address deliveryAddress;

    private Address address;
    private Location pickupLocation;

}
