/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.context.model;

import com.fluentretail.api.model.attribute.Attribute;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@Builder
@AllArgsConstructor
public class Fulfilment {

    private String id;
    private String ref;
    private String status;
    private String fulfilmentChoiceRef;
    private Date createdOn;
    private Date updatedOn;
    private String deliveryType;
    private String type;
    private String eta;
    private Date expiryTime;
    private LocationLink fromLocation;
    private Address fromAddress;
    private Address toAddress;
    private Customer user;
    private List<Attribute> attributes;
    private List<FulfilmentItem> items;

    // ===== INNER CLASSES =====

    @Data
    @Builder
    @AllArgsConstructor
    public static class LocationLink {
        private String ref;
    }

    @Data
    @Builder(toBuilder = true)
    @AllArgsConstructor
    public static class FulfilmentItem {
        private String id;
        private String ref;
        private String status;
        private Integer requestedQuantity;
        private Integer filledQuantity;
        private Integer rejectedQuantity;
        private OrderItem orderItem;
        private List<Attribute> attributes;
        private List<RejectedItem> rejectedItems;

        @Data
        @Builder
        @AllArgsConstructor
        public static class RejectedItem {
            private String id;
            private Integer quantity;
            private RejectReason rejectReason;

            @Data
            @Builder
            @AllArgsConstructor
            public static class RejectReason {
                private String label;
                private String value;
            }
        }
    }
}