/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.context.model;

import com.fluentretail.api.model.attribute.Attribute;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@Builder
@AllArgsConstructor
public class Customer {

    private String id;
    private String ref;
    private String status;
    private Date createdOn;
    private Date updatedOn;
    private String title;
    private String department;
    private String country;
    private String firstName;
    private String lastName;
    private String username;
    private String primaryEmail;
    private String primaryPhone;
    private String timezone;
    private Boolean promotionOptIn;
    private Retailer retailer;
    private List<Attribute> attributes;

}
