/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.context;

import com.fluentcommerce.util.sourcing.context.model.OrderItem;

import java.util.List;

/**
 * Interface representing the logic that would be used to calculate unfulfilled items based on {@link SourcingContext}
 */
public interface UnfulfilledItemProcessor {
    /**
     * Calculate unfulfilled items based on {@link SourcingContext}
     *
     * @param sourcingContext {@link SourcingContext} from which unfulfilled items should be calculated
     * @return list of unfulfilled items
     */
    List<OrderItem> process(SourcingContext sourcingContext);
}
