/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.context;

import com.fluentcommerce.util.sourcing.context.model.Customer;
import com.fluentcommerce.util.sourcing.context.model.Fulfilment;
import com.fluentcommerce.util.sourcing.context.model.FulfilmentChoice;
import com.fluentcommerce.util.sourcing.context.model.OrderItem;
import com.fluentretail.api.model.attribute.Attribute;

import java.util.Date;
import java.util.List;

/**
 * Represents a common data interface for a context required during Sourcing Request evaluation
 */
public interface SourcingContext {

    String getId();

    String getRef();

    String getRef2();

    String getTag1();

    String getTag2();

    String getTag3();

    String getType();

    String getStatus();

    Date getCreatedOn();

    Date getUpdatedOn();

    List<Attribute> getAttributes();

    Double getTotalPrice();

    Double getTotalTaxPrice();

    FulfilmentChoice getFulfilmentChoice();

    List<OrderItem> getItems();

    List<OrderItem> getUnfulfilledItems();

    List<Fulfilment> getFulfilments();

    Customer getCustomer();

    /**
     * Represents a common Builder interface required to create a {@link SourcingContext} by utils
     */
    interface SourcingContextBuilder {
        SourcingContextBuilder id(String id);

        SourcingContextBuilder ref(String ref);

        SourcingContextBuilder ref2(String ref2);

        SourcingContextBuilder tag1(String tag1);

        SourcingContextBuilder tag2(String tag2);

        SourcingContextBuilder tag3(String tag3);

        SourcingContextBuilder type(String type);

        SourcingContextBuilder status(String status);

        SourcingContextBuilder createdOn(Date createdOn);

        SourcingContextBuilder updatedOn(Date updatedOn);

        SourcingContextBuilder attributes(List<Attribute> attributes);

        SourcingContextBuilder totalPrice(Double totalPrice);

        SourcingContextBuilder totalTaxPrice(Double totalTaxPrice);

        SourcingContextBuilder fulfilmentChoice(FulfilmentChoice fulfilmentChoice);

        SourcingContextBuilder items(List<OrderItem> items);

        SourcingContextBuilder unfulfilledItems(List<OrderItem> unfulfilledItems);

        SourcingContextBuilder fulfilments(List<Fulfilment> fulfilments);

        SourcingContextBuilder customer(Customer customer);

        SourcingContext build();
    }

    SourcingContextBuilder toBuilder();

}
