/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.condition;

import com.fasterxml.jackson.databind.JsonNode;

/**
 * Represents a contract for evaluating a sourcing condition against a given context.
 *
 * <p>Implementations of this interface define specific business rules that are
 * evaluated dynamically during the sourcing process. The input context is
 * represented as a {@link JsonNode}, allowing flexible access to structured data
 * such as order details, product attributes, inventory states, and more.</p>
 */
public interface SourcingCondition {

    /**
     * Evaluates the sourcing condition using the provided context.
     *
     * @param sourcingContext a {@link JsonNode} containing data used for evaluation;
     *                        typically includes fields related to the order, location,
     *                        inventory, or product information.
     * @return {@code true} if the condition is satisfied based on the context,
     * {@code false} otherwise
     */
    boolean evaluateWithContext(JsonNode sourcingContext);
}
