/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.dynamic.graphql;

import com.apollographql.apollo.api.Query;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;
import com.fluentcommerce.graphql.queries.introspection.IntrospectionQuery;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentretail.rubix.v2.context.Context;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLIntrospectionUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLIntrospectionUtils.class);
    private static IntrospectionQuery.Data introspectionData = null;
    private static final Map<String, List<QueryParameter>> queryArgs = new HashMap<String, List<QueryParameter>>();
    private static final Map<String, Optional<IntrospectionQuery.Type>> queryTypes = new HashMap<String, Optional<IntrospectionQuery.Type>>();
    private static final Map<String, Optional<IntrospectionQuery.Field>> queries = new HashMap<String, Optional<IntrospectionQuery.Field>>();
    private static Map<String, List<QueryParameter>> mutationFields = new HashMap<String, List<QueryParameter>>();

    public static IntrospectionQuery.Data getSchema(Context context) {
        if (introspectionData == null) {
            introspectionData = (IntrospectionQuery.Data)context.api().query((Query)IntrospectionQuery.builder().build());
        }
        return introspectionData;
    }

    public static boolean isSchemaLoaded() {
        return introspectionData != null;
    }

    public static List<QueryParameter> getArgsForQuery(Context context, String queryName) {
        if (!queryArgs.containsKey(queryName)) {
            GraphQLIntrospectionUtils.getQuery(context, queryName).ifPresent(q -> queryArgs.put(queryName, q.args().stream().map(GraphQLIntrospectionUtils::argToQueryParam).collect(Collectors.toList())));
        }
        return queryArgs.get(queryName);
    }

    public static Optional<IntrospectionQuery.Type> getResponseTypeForQuery(Context context, String queryName) {
        if (!queryTypes.containsKey(queryName)) {
            GraphQLIntrospectionUtils.getQuery(context, queryName).ifPresent(q -> queryTypes.put(queryName, GraphQLIntrospectionUtils.getSchema(context).__schema().types().stream().filter(t -> t.name().equals(q.type().name())).findFirst()));
        }
        return queryTypes.get(queryName);
    }

    public static Optional<IntrospectionQuery.Field> getField(IntrospectionQuery.Type type, String fieldName) {
        return type.fields().stream().filter(f -> fieldName.equals(f.name())).findFirst();
    }

    public static List<IntrospectionQuery.InputField> getFieldsForInput(Context context, String inputName) {
        Optional<IntrospectionQuery.Type> foundType = GraphQLIntrospectionUtils.getSchema(context).__schema().types().stream().filter(type -> type.name().equals(inputName)).findFirst();
        if (foundType.isPresent()) {
            return foundType.get().inputFields();
        }
        return Collections.emptyList();
    }

    public static Optional<IntrospectionQuery.Type> getResponseTypeForField(Context context, IntrospectionQuery.Field field) {
        IntrospectionQuery.Type2 type = field.type();
        String typeName = type.name();
        if (type.ofType() != null) {
            typeName = type.ofType().name();
            if (type.ofType().ofType() != null) {
                typeName = type.ofType().ofType().name();
                if (type.ofType().ofType().ofType() != null) {
                    typeName = type.ofType().ofType().ofType().name();
                    if (type.ofType().ofType().ofType().ofType() != null) {
                        typeName = type.ofType().ofType().ofType().ofType().name();
                    }
                }
            }
        }
        String finalTypeName = typeName;
        return GraphQLIntrospectionUtils.getSchema(context).__schema().types().stream().filter(t -> finalTypeName.equals(t.name())).findFirst();
    }

    public static Optional<IntrospectionQuery.Type> getResponseTypeForArg(Context context, IntrospectionQuery.Arg field) {
        IntrospectionQuery.Type1 type = field.type();
        String typeName = type.name();
        if (type.ofType() != null) {
            typeName = type.ofType().name();
            if (type.ofType().ofType() != null) {
                typeName = type.ofType().ofType().name();
                if (type.ofType().ofType().ofType() != null) {
                    typeName = type.ofType().ofType().ofType().name();
                    if (type.ofType().ofType().ofType().ofType() != null) {
                        typeName = type.ofType().ofType().ofType().ofType().name();
                    }
                }
            }
        }
        String finalTypeName = typeName;
        return GraphQLIntrospectionUtils.getSchema(context).__schema().types().stream().filter(t -> finalTypeName.equals(t.name())).findFirst();
    }

    public static Optional<IntrospectionQuery.Field> getQuery(Context context, String queryName) {
        if (!queries.containsKey(queryName)) {
            Optional<IntrospectionQuery.Type> rootQuery = GraphQLIntrospectionUtils.getRootQuery(context);
            Optional<IntrospectionQuery.Field> resultQuery = GraphQLIntrospectionUtils.findQuery(queryName, context, rootQuery);
            queries.put(queryName, resultQuery);
        }
        return queries.get(queryName);
    }

    public static Optional<QueryParameter> getInputFieldLikeQueryParam(Context context, String path) {
        Optional<IntrospectionQuery.Type> rootQuery = GraphQLIntrospectionUtils.getRootQuery(context);
        return GraphQLIntrospectionUtils.findInputParameterLikeQueryParam(path, context, rootQuery);
    }

    private static Optional<IntrospectionQuery.Type> getRootQuery(Context context) {
        return GraphQLIntrospectionUtils.getSchema(context).__schema().types().stream().filter(type -> "Query".equalsIgnoreCase(type.name())).findFirst();
    }

    private static Optional<QueryParameter> findInputParameterLikeQueryParam(String path, Context context, Optional<IntrospectionQuery.Type> rootQuery) {
        if (!rootQuery.isPresent()) {
            return Optional.empty();
        }
        List<String> pathParts = Arrays.asList(path.split("\\."));
        Optional<Object> query = Optional.empty();
        Optional<IntrospectionQuery.Type> queryType = rootQuery;
        Optional<Object> inputFieldType = Optional.empty();
        Optional<Object> inputArgument = Optional.empty();
        for (int i = 0; i < pathParts.size(); ++i) {
            String part = pathParts.get(i);
            if (inputArgument.isPresent() && (inputFieldType = GraphQLIntrospectionUtils.getResponseTypeForArg(context, (IntrospectionQuery.Arg)inputArgument.get())).isPresent()) {
                Optional<IntrospectionQuery.InputField> inputField = ((IntrospectionQuery.Type)inputFieldType.get()).inputFields().stream().filter(f -> part.equals(f.name())).findFirst();
                if (inputField.isPresent()) {
                    return Optional.of(GraphQLIntrospectionUtils.inputFieldToQueryParam(inputField.get()));
                }
                log.warn("Can't find Input parameter for path {}", (Object)path);
                return Optional.empty();
            }
            if (inputFieldType.isPresent()) continue;
            if (query.isPresent()) {
                inputArgument = ((IntrospectionQuery.Field)query.get()).args().stream().filter(arg -> StringUtils.equals((CharSequence)arg.name(), (CharSequence)part)).findFirst();
            }
            if ((query = GraphQLIntrospectionUtils.findQuery(part, context, queryType)).isPresent()) {
                queryType = GraphQLIntrospectionUtils.getResponseTypeForField(context, (IntrospectionQuery.Field)query.get());
                continue;
            }
            if (inputArgument.isPresent()) continue;
            log.warn("Can't find Input parameter and query for path {}", (Object)path);
        }
        if (!inputFieldType.isPresent() && inputArgument.isPresent()) {
            return Optional.of(GraphQLIntrospectionUtils.argToQueryParam((IntrospectionQuery.Arg)inputArgument.get()));
        }
        log.warn("Can't find Input parameter for path {}", (Object)path);
        return Optional.empty();
    }

    private static Optional<IntrospectionQuery.Field> findQuery(String queryName, Context context, Optional<IntrospectionQuery.Type> rootQuery) {
        if (!rootQuery.isPresent()) {
            return Optional.empty();
        }
        ArrayList<String> queryParts = new ArrayList<String>(Arrays.asList(queryName.split("\\.")));
        if (queryParts.size() <= 1) {
            if (StringUtils.endsWith((CharSequence)rootQuery.get().name(), (CharSequence)"Connection")) {
                return GraphQLIntrospectionUtils.findQuery("edges.node." + queryName, context, rootQuery);
            }
            return rootQuery.map(IntrospectionQuery.Type::fields).filter(Objects::nonNull).flatMap(fields -> fields.stream().filter(field -> field.name().equals(queryName)).findFirst());
        }
        Optional<IntrospectionQuery.Field> subQuery = Optional.empty();
        Optional<IntrospectionQuery.Type> subQueryType = rootQuery;
        for (int i = 0; i < queryParts.size(); ++i) {
            String part = (String)queryParts.get(i);
            subQuery = GraphQLIntrospectionUtils.getField(subQueryType.get(), part);
            if (!subQuery.isPresent()) {
                return Optional.empty();
            }
            subQueryType = GraphQLIntrospectionUtils.getResponseTypeForField(context, subQuery.get());
            if (!subQueryType.isPresent()) {
                return Optional.empty();
            }
            if (!StringUtils.endsWith((CharSequence)subQueryType.get().name(), (CharSequence)"Connection") || i + 1 >= queryParts.size()) continue;
            queryParts.add(i + 1, "edges");
            queryParts.add(i + 2, "node");
        }
        return subQuery;
    }

    private static QueryParameter argToQueryParam(IntrospectionQuery.Arg arg) {
        IntrospectionQuery.Type1 type = arg.type();
        String stringType = type.name();
        boolean isMandatory = type.kind().name().equals("NON_NULL");
        boolean isList = type.kind().name().equals("LIST");
        if (type.ofType() != null) {
            IntrospectionQuery.OfType ofType = type.ofType();
            stringType = ofType.name();
            isMandatory = isMandatory || ofType.kind().name().equals("NON_NULL");
            boolean bl = isList = isList || isMandatory && ofType.kind().name().equals("LIST");
            if (ofType.ofType() != null) {
                IntrospectionQuery.OfType1 ofType1 = ofType.ofType();
                stringType = ofType1.name();
                isMandatory = isMandatory || ofType1.kind().name().equals("NON_NULL");
                boolean bl2 = isList = isList || ofType1.kind().name().equals("LIST");
                if (ofType1.ofType() != null) {
                    IntrospectionQuery.OfType2 ofType2 = ofType1.ofType();
                    stringType = ofType2.name();
                    isMandatory = isMandatory || ofType2.kind().name().equals("NON_NULL");
                    boolean bl3 = isList = isList || ofType2.kind().name().equals("LIST");
                    if (ofType2.ofType() != null) {
                        IntrospectionQuery.OfType3 ofType3 = ofType2.ofType();
                        stringType = ofType3.name();
                        isMandatory = isMandatory || ofType3.kind().name().equals("NON_NULL");
                        isList = isList || ofType3.kind().name().equals("LIST");
                    }
                }
            }
        }
        return new QueryParameter(arg.name(), stringType, isMandatory, isList);
    }

    public static List<QueryParameter> getFieldsForMutation(Context context, String inputName) {
        if (!mutationFields.containsKey(inputName)) {
            IntrospectionQuery.Data intro = GraphQLIntrospectionUtils.getSchema(context);
            Optional<IntrospectionQuery.Type> inputType = intro.__schema().types().stream().filter(type -> type.name().equals(inputName)).findFirst();
            inputType.ifPresent(in -> {
                List fields = in.inputFields().stream().map(GraphQLIntrospectionUtils::inputFieldToQueryParam).collect(Collectors.toList());
                mutationFields.put(inputName, fields);
            });
        }
        return mutationFields.get(inputName);
    }

    private static QueryParameter inputFieldToQueryParam(IntrospectionQuery.InputField field) {
        IntrospectionQuery.Type3 type = field.type();
        String stringType = type.name();
        boolean isMandatory = type.kind().name().equals("NON_NULL");
        boolean isList = type.kind().name().equals("LIST");
        if (type.ofType() != null) {
            IntrospectionQuery.OfType8 ofType = type.ofType();
            stringType = ofType.name();
            isMandatory = isMandatory || ofType.kind().name().equals("NON_NULL");
            boolean bl = isList = isList || ofType.kind().name().equals("LIST");
            if (ofType.ofType() != null) {
                IntrospectionQuery.OfType9 ofType1 = ofType.ofType();
                stringType = ofType1.name();
                isMandatory = isMandatory || ofType1.kind().name().equals("NON_NULL");
                boolean bl2 = isList = isList || ofType1.kind().name().equals("LIST");
                if (ofType1.ofType() != null) {
                    IntrospectionQuery.OfType10 ofType2 = ofType1.ofType();
                    stringType = ofType2.name();
                    isMandatory = isMandatory || ofType2.kind().name().equals("NON_NULL");
                    boolean bl3 = isList = isList || ofType2.kind().name().equals("LIST");
                    if (ofType2.ofType() != null) {
                        IntrospectionQuery.OfType11 ofType3 = ofType2.ofType();
                        stringType = ofType3.name();
                        isMandatory = isMandatory || ofType3.kind().name().equals("NON_NULL");
                        isList = isList || ofType3.kind().name().equals("LIST");
                    }
                }
            }
        }
        return new QueryParameter(field.name(), stringType, isMandatory, isList);
    }

    public static List<String> deriveFieldsFromJSON(Map<String, JsonSchema> allSchemas, JsonSchema node, String path) {
        if (node.isObjectSchema() && !node.asObjectSchema().getProperties().isEmpty()) {
            return node.asObjectSchema().getProperties().entrySet().stream().filter(e -> !((JsonSchema)e.getValue()).isArraySchema() || StringUtils.contains((CharSequence)((CharSequence)e.getKey()), (CharSequence)"attributes")).flatMap(e -> {
                String nextPath = path + (path.length() > 0 ? "." : "") + (String)e.getKey();
                if (e.getValue() instanceof ReferenceSchema) {
                    JsonSchema schema = (JsonSchema)allSchemas.get(((JsonSchema)e.getValue()).get$ref());
                    if (schema != null) {
                        return GraphQLIntrospectionUtils.deriveFieldsFromJSON(allSchemas, schema, nextPath).stream();
                    }
                    log.warn("Can't resolve reference {}, urn {}", (Object)nextPath, (Object)((JsonSchema)e.getValue()).get$ref());
                    return Stream.empty();
                }
                return GraphQLIntrospectionUtils.deriveFieldsFromJSON(allSchemas, (JsonSchema)e.getValue(), nextPath).stream();
            }).collect(Collectors.toList());
        }
        if (node.isArraySchema()) {
            return GraphQLIntrospectionUtils.deriveFieldsFromJSON(allSchemas, node.asArraySchema().getItems().asSingleItems().getSchema(), path);
        }
        if (node instanceof ReferenceSchema) {
            JsonSchema schema = allSchemas.get(node.get$ref());
            if (schema != null) {
                return GraphQLIntrospectionUtils.deriveFieldsFromJSON(allSchemas, schema, path);
            }
            log.warn("Can't resolve reference {}, urn {}", (Object)path, (Object)node.get$ref());
        }
        return ImmutableList.of((Object)path);
    }

    public static List<String> deriveFieldsFromJSON(JsonSchema node, String path) {
        Map<String, JsonSchema> schemaList = JsonUtils.collectAllSchemas(node);
        return GraphQLIntrospectionUtils.deriveFieldsFromJSON(schemaList, node, path);
    }

    public static final class CollectedQueryParameter {
        private final QueryParameter queryParameter;
        private final String alias;
        private final String path;
        private final Object value;

        @ConstructorProperties(value={"queryParameter", "alias", "path", "value"})
        @Generated
        public CollectedQueryParameter(QueryParameter queryParameter, String alias, String path, Object value) {
            this.queryParameter = queryParameter;
            this.alias = alias;
            this.path = path;
            this.value = value;
        }

        @Generated
        public QueryParameter getQueryParameter() {
            return this.queryParameter;
        }

        @Generated
        public String getAlias() {
            return this.alias;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CollectedQueryParameter)) {
                return false;
            }
            CollectedQueryParameter other = (CollectedQueryParameter)o;
            QueryParameter this$queryParameter = this.getQueryParameter();
            QueryParameter other$queryParameter = other.getQueryParameter();
            if (this$queryParameter == null ? other$queryParameter != null : !((Object)this$queryParameter).equals(other$queryParameter)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            QueryParameter $queryParameter = this.getQueryParameter();
            result = result * 59 + ($queryParameter == null ? 43 : ((Object)$queryParameter).hashCode());
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GraphQLIntrospectionUtils.CollectedQueryParameter(queryParameter=" + this.getQueryParameter() + ", alias=" + this.getAlias() + ", path=" + this.getPath() + ", value=" + this.getValue() + ")";
        }
    }

    public static final class QueryParameter {
        private final String name;
        private final String type;
        private final boolean required;
        private final boolean list;

        public String typeDefinition() {
            StringBuilder graphQlType = new StringBuilder();
            graphQlType.append(this.type);
            if (this.required) {
                graphQlType.append("!");
            }
            if (this.list) {
                graphQlType.insert(0, "[");
                graphQlType.append("]");
            }
            return graphQlType.toString();
        }

        @ConstructorProperties(value={"name", "type", "required", "list"})
        @Generated
        public QueryParameter(String name, String type, boolean required, boolean list) {
            this.name = name;
            this.type = type;
            this.required = required;
            this.list = list;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public boolean isRequired() {
            return this.required;
        }

        @Generated
        public boolean isList() {
            return this.list;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryParameter)) {
                return false;
            }
            QueryParameter other = (QueryParameter)o;
            if (this.isRequired() != other.isRequired()) {
                return false;
            }
            if (this.isList() != other.isList()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRequired() ? 79 : 97);
            result = result * 59 + (this.isList() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GraphQLIntrospectionUtils.QueryParameter(name=" + this.getName() + ", type=" + this.getType() + ", required=" + this.isRequired() + ", list=" + this.isList() + ")";
        }
    }
}

