/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.dynamic.graphql;

import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.dynamic.graphql.DynamicDataTypes;
import com.fluentcommerce.util.dynamic.graphql.DynamicOperationName;
import com.fluentcommerce.util.dynamic.graphql.GraphQLIntrospectionUtils;
import com.fluentretail.rubix.event.Event;
import com.fluentretail.rubix.v2.context.Context;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DynamicUpdateMutation
implements Mutation<DynamicDataTypes.MutationOuterData, DynamicDataTypes.MutationOuterData, DynamicDataTypes.MutationDynamicVariables> {
    private static final String RESPONSE_ALIAS = "r";
    private final String queryName;
    private final String inputName;
    private final String queryString;
    private final DynamicDataTypes.MutationDynamicVariables variables;
    private final OperationName name;
    private final Boolean errorOnInvalidVariables;

    public DynamicUpdateMutation(Context context, String key, Object value) {
        this(context, (Map<String, Object>)ImmutableMap.of((Object)key, (Object)value), true);
    }

    public DynamicUpdateMutation(Context context, Object value) {
        this(context, value, false);
    }

    public DynamicUpdateMutation(Context context, Object value, boolean errorOnInvalidVariables) {
        this(context, JsonUtils.pojoToMap(value), errorOnInvalidVariables);
    }

    public DynamicUpdateMutation(Context context, Map<String, Object> variables) {
        this(context, variables, false);
    }

    public DynamicUpdateMutation(Context context, Map<String, Object> variables, boolean errorOnInvalidVariables) {
        this.errorOnInvalidVariables = errorOnInvalidVariables;
        this.queryName = this.resolveQueryFromContext(context);
        this.inputName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, this.queryName) + "Input";
        this.queryString = this.buildQueryString();
        this.variables = this.resolveVariablesForQuery(this.queryName, context, variables);
        this.name = new DynamicOperationName(this.queryName);
    }

    private String resolveQueryFromContext(Context context) {
        String queryName;
        String type;
        switch (type = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, context.getEvent().getEntityType())) {
            case "FulfilmentOptions": {
                queryName = "updateFulfilmentOption";
                break;
            }
            default: {
                queryName = "update" + type;
            }
        }
        return queryName;
    }

    private String buildQueryString() {
        return String.format("mutation %s($input:%s!) { %s:%s(input:$input) { __typename ref } }", this.queryName, this.inputName, RESPONSE_ALIAS, this.queryName);
    }

    public String getQueryType() {
        return "DynamicUpdateMutation";
    }

    private DynamicDataTypes.MutationDynamicVariables resolveVariablesForQuery(String query, Context context, Map<String, Object> passedVariables) {
        String inputName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, query) + "Input";
        List<GraphQLIntrospectionUtils.QueryParameter> fields = GraphQLIntrospectionUtils.getFieldsForMutation(context, inputName);
        try {
            Map<String, Object> derivedVariables = fields.stream().filter(GraphQLIntrospectionUtils.QueryParameter::isRequired).map(p -> this.mapParameter((GraphQLIntrospectionUtils.QueryParameter)p, context)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, String> fieldTypes = fields.stream().collect(Collectors.toMap(GraphQLIntrospectionUtils.QueryParameter::getName, GraphQLIntrospectionUtils.QueryParameter::getType));
            List<String> invalidVars = passedVariables.keySet().stream().filter(f -> !fieldTypes.containsKey(f)).collect(Collectors.toList());
            if (this.errorOnInvalidVariables.booleanValue() && !invalidVars.isEmpty()) {
                throw new IllegalArgumentException(String.format("Invalid parameters for dynamic update query '%s': %s", this.queryName, invalidVars));
            }
            invalidVars.forEach(passedVariables::remove);
            return new DynamicDataTypes.MutationDynamicVariables((Map<String, Object>)ImmutableMap.of((Object)"input", (Object)ImmutableMap.builder().putAll(passedVariables).putAll(derivedVariables).build()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to build DynamicQuery for context: " + JsonUtils.objectToNode(context));
        }
    }

    private Map.Entry<String, Object> mapParameter(GraphQLIntrospectionUtils.QueryParameter param, Context context) {
        String name = param.getName();
        Event event = context.getEvent();
        switch (name) {
            case "ref": {
                return new AbstractMap.SimpleEntry<String, Object>(name, event.getEntityRef());
            }
            case "id": {
                return new AbstractMap.SimpleEntry<String, Object>(name, event.getEntityId());
            }
            case "retailer": {
                return new AbstractMap.SimpleEntry<String, ImmutableMap>(name, ImmutableMap.of((Object)"id", (Object)event.getRetailerId()));
            }
            case "catalogue": {
                return new AbstractMap.SimpleEntry<String, ImmutableMap>(name, ImmutableMap.of((Object)"ref", (Object)event.getRootEntityRef()));
            }
            case "returnOrder": {
                return new AbstractMap.SimpleEntry<String, ImmutableMap>(name, ImmutableMap.of((Object)"ref", (Object)event.getRootEntityRef(), (Object)"retailer", (Object)ImmutableMap.of((Object)"id", (Object)event.getRetailerId())));
            }
        }
        throw new IllegalArgumentException("Cannot build a dynamic query with parameter: " + name);
    }

    public String queryDocument() {
        return this.queryString;
    }

    public DynamicDataTypes.MutationDynamicVariables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<DynamicDataTypes.MutationOuterData> responseFieldMapper() {
        return readerOuter -> {
            DynamicDataTypes.MutationInnerData inner = (DynamicDataTypes.MutationInnerData)readerOuter.readObject(ResponseField.forObject((String)RESPONSE_ALIAS, (String)RESPONSE_ALIAS, null, (boolean)true, null), reader -> {
                String __typename = reader.readString(ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, null));
                String ref = reader.readString(ResponseField.forString((String)"ref", (String)"ref", null, (boolean)false, null));
                return new DynamicDataTypes.MutationInnerData(__typename, ref);
            });
            return new DynamicDataTypes.MutationOuterData(inner);
        };
    }

    public DynamicDataTypes.MutationOuterData wrapData(DynamicDataTypes.MutationOuterData data) {
        return data;
    }

    @Nonnull
    public OperationName name() {
        return this.name;
    }

    @Nonnull
    public String operationId() {
        return UUID.randomUUID().toString();
    }

    public static final class MapBasedInputFieldMarshaller
    implements InputFieldMarshaller {
        private final Map<String, Object> values;

        public MapBasedInputFieldMarshaller(Map<String, Object> values) {
            this.values = values;
        }

        public void marshal(InputFieldWriter writer) throws IOException {
            for (Map.Entry<String, Object> e : this.values.entrySet()) {
                this.addItem(writer, e.getKey(), e.getValue());
            }
        }

        private void addItem(InputFieldWriter writer, String key, Object value) throws IOException {
            if (value instanceof List) {
                writer.writeList(key, listWriter -> {
                    for (Object v : (List)value) {
                        if (v instanceof String) {
                            listWriter.writeString((String)v);
                            continue;
                        }
                        if (v instanceof Integer) {
                            listWriter.writeInt((Integer)v);
                            continue;
                        }
                        if (v instanceof Double) {
                            listWriter.writeDouble((Double)v);
                            continue;
                        }
                        if (v instanceof Boolean) {
                            listWriter.writeBoolean((Boolean)v);
                            continue;
                        }
                        if (v instanceof Long) {
                            listWriter.writeLong((Long)v);
                            continue;
                        }
                        if (v instanceof Map) {
                            listWriter.writeObject((InputFieldMarshaller)new MapBasedInputFieldMarshaller((Map)v));
                            continue;
                        }
                        listWriter.writeObject((InputFieldMarshaller)new MapBasedInputFieldMarshaller(JsonUtils.pojoToMap(v)));
                    }
                });
            } else if (value instanceof String) {
                writer.writeString(key, (String)value);
            } else if (value instanceof Integer) {
                writer.writeInt(key, (Integer)value);
            } else if (value instanceof Double) {
                writer.writeDouble(key, (Double)value);
            } else if (value instanceof Boolean) {
                writer.writeBoolean(key, (Boolean)value);
            } else if (value instanceof Long) {
                writer.writeLong(key, (Long)value);
            } else if (value instanceof Map) {
                writer.writeObject(key, (InputFieldMarshaller)new MapBasedInputFieldMarshaller((Map)value));
            } else {
                writer.writeObject(key, (InputFieldMarshaller)new MapBasedInputFieldMarshaller(JsonUtils.pojoToMap(value)));
            }
        }
    }
}

