/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.dynamic.graphql;

import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ScalarType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fluentcommerce.graphql.queries.introspection.IntrospectionQuery;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.dynamic.graphql.DynamicDataTypes;
import com.fluentcommerce.util.dynamic.graphql.GraphQLIntrospectionUtils;
import com.fluentretail.api.v2.model.Entity;
import com.fluentretail.graphql.type.CustomType;
import com.fluentretail.rubix.event.Event;
import com.fluentretail.rubix.v2.context.Context;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicEntityQuery
implements Query<DynamicDataTypes.QueryDynamicData, DynamicDataTypes.QueryDynamicData, DynamicDataTypes.QueryDynamicVariables> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicEntityQuery.class);
    private static final String RESPONSE_ALIAS = "r";
    private static final String ARG_VAL_PATTERN = "%s:$%s";
    private static final String ARG_OBJECT_VAL_PATTERN = "%s:{ %s }";
    private final String queryName;
    private final String fullQueryString;
    private final DynamicDataTypes.QueryDynamicVariables dynamicVariables;
    private final List<GraphQLIntrospectionUtils.CollectedQueryParameter> collectedQueryParams;
    private final OperationName name;

    public DynamicEntityQuery(Context context, Class<?> responseType) {
        this(context, GraphQLIntrospectionUtils.deriveFieldsFromJSON(JsonUtils.getSchemaForClass(responseType), ""));
    }

    public DynamicEntityQuery(Context context, Class<?> responseType, Map<String, Object> queryParams) {
        this(context, GraphQLIntrospectionUtils.deriveFieldsFromJSON(JsonUtils.getSchemaForClass(responseType), ""), null, queryParams);
    }

    public DynamicEntityQuery(Context context, List<String> paths) {
        this(context, paths, null, null);
    }

    public DynamicEntityQuery(Context context, List<String> paths, String graphqlQueryName, Map<String, Object> queryParameters) {
        this.queryName = StringUtils.isEmpty((CharSequence)graphqlQueryName) ? this.resolveQueryFromContext(context) : graphqlQueryName;
        this.name = () -> this.queryName;
        this.collectedQueryParams = this.collectQueryParams(queryParameters == null ? new HashMap<String, Object>() : queryParameters, this.queryName, context);
        this.dynamicVariables = this.resolveVariablesForQuery(this.queryName, this.collectedQueryParams, context);
        String argDef = this.resolveArgDefinitionStructure(this.queryName, this.collectedQueryParams, context);
        String argVal = this.resolveArgValueStructure(this.queryName, this.collectedQueryParams, context);
        ResponseTreeNode response = this.resolveResponseQueryStructure(paths, this.queryName, context);
        this.fullQueryString = this.buildQueryString(argDef, argVal, response.toQueryFragment(Collections.singletonList(this.queryName), context, this.collectedQueryParams));
    }

    private String resolveQueryFromContext(Context context) {
        String queryName;
        switch (context.getEvent().getEntityType()) {
            case "PRODUCT": {
                if (StringUtils.isEmpty((CharSequence)context.getEvent().getEntitySubtype())) {
                    queryName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, context.getEvent().getEntityType());
                    break;
                }
                queryName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, context.getEvent().getEntitySubtype()) + "Product";
                break;
            }
            default: {
                queryName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, context.getEvent().getEntityType());
            }
        }
        if (GraphQLIntrospectionUtils.getArgsForQuery(context, queryName) == null) {
            queryName = queryName + "ById";
        }
        return queryName;
    }

    private String buildQueryString(String argDefinition, String argValues, String response) {
        return String.format("query %s(%s) { %s:%s(%s) %s }", this.queryName, argDefinition, RESPONSE_ALIAS, this.queryName, argValues, response);
    }

    private String resolveArgDefinitionStructure(String query, List<GraphQLIntrospectionUtils.CollectedQueryParameter> collectedQueryParams, Context context) {
        BiFunction<String, String, String> toDefinition = (name, type) -> String.format("$%s:%s", name, type);
        Stream<String> argDefinitionFromParameters = collectedQueryParams.stream().map(collectedQueryParameter -> (String)toDefinition.apply(collectedQueryParameter.getAlias(), collectedQueryParameter.getQueryParameter().typeDefinition()));
        Stream<String> argDefinitionFromQuery = GraphQLIntrospectionUtils.getArgsForQuery(context, query).stream().filter(a -> {
            String argPath = query + "." + a.getName();
            boolean isArgumentInQueryParams = collectedQueryParams.stream().anyMatch(collectedQueryParameter -> StringUtils.equals((CharSequence)argPath, (CharSequence)collectedQueryParameter.getPath()));
            return (a.isRequired() || a.getName().equals("id")) && !isArgumentInQueryParams;
        }).map(p -> (String)toDefinition.apply(p.getName(), p.typeDefinition()));
        return Stream.concat(argDefinitionFromQuery, argDefinitionFromParameters).collect(Collectors.joining(", "));
    }

    private String resolveArgValueStructure(String query, List<GraphQLIntrospectionUtils.CollectedQueryParameter> collectedQueryParams, Context context) {
        return GraphQLIntrospectionUtils.getArgsForQuery(context, query).stream().filter(a -> a.isRequired() || a.getName().equals("id")).map(p -> {
            String argPath = query + "." + p.getName();
            Optional<GraphQLIntrospectionUtils.CollectedQueryParameter> providedQueryParam = collectedQueryParams.stream().filter(cqp -> StringUtils.equals((CharSequence)argPath, (CharSequence)cqp.getPath())).findFirst();
            if (providedQueryParam.isPresent()) {
                return String.format(ARG_VAL_PATTERN, p.getName(), providedQueryParam.get().getAlias());
            }
            return String.format(ARG_VAL_PATTERN, p.getName(), p.getName());
        }).collect(Collectors.joining(", "));
    }

    private List<GraphQLIntrospectionUtils.CollectedQueryParameter> collectQueryParams(Map<String, Object> queryParameters, String queryName, Context context) {
        ArrayList<GraphQLIntrospectionUtils.CollectedQueryParameter> collectedQueryParameters = new ArrayList<GraphQLIntrospectionUtils.CollectedQueryParameter>();
        queryParameters.entrySet().stream().map(keyValue -> this.getParamAliasAndValue((String)keyValue.getKey(), keyValue.getValue())).flatMap(Collection::stream).forEach(keyValue -> {
            String paramPath = queryName + "." + (String)keyValue.getKey();
            String paramAlias = paramPath.replace(".", "_");
            Optional<GraphQLIntrospectionUtils.QueryParameter> queryParameterFromSchema = GraphQLIntrospectionUtils.getInputFieldLikeQueryParam(context, paramPath);
            queryParameterFromSchema.ifPresent(q -> collectedQueryParameters.add(new GraphQLIntrospectionUtils.CollectedQueryParameter((GraphQLIntrospectionUtils.QueryParameter)q, paramAlias, paramPath, keyValue.getValue())));
        });
        return collectedQueryParameters;
    }

    private List<AbstractMap.SimpleEntry<String, Object>> getParamAliasAndValue(String key, Object value) {
        ArrayList<AbstractMap.SimpleEntry<String, Object>> resultKeys = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();
        if (value instanceof Map) {
            Map valueMap = (Map)value;
            valueMap.forEach((key1, value1) -> {
                List<AbstractMap.SimpleEntry<String, Object>> nextKeys = this.getParamAliasAndValue((String)key1, value1);
                nextKeys.forEach(nextKey -> resultKeys.add(new AbstractMap.SimpleEntry(key + "." + (String)nextKey.getKey(), nextKey.getValue())));
            });
        } else {
            resultKeys.add(new AbstractMap.SimpleEntry<String, Object>(key, value));
        }
        return resultKeys;
    }

    private ResponseTreeNode resolveResponseQueryStructure(List<String> paths, String query, Context context) {
        ResponseTreeNode root = new ResponseTreeNode();
        Optional<IntrospectionQuery.Type> type = GraphQLIntrospectionUtils.getResponseTypeForQuery(context, query);
        if (!type.isPresent()) {
            throw new RuntimeException("problem loading type for query: " + query);
        }
        paths.forEach(path -> {
            try {
                this.resolvePath(root, (IntrospectionQuery.Type)type.get(), (List<String>)ImmutableList.copyOf((Object[])path.split("\\.")), context);
            }
            catch (RuntimeException e) {
                log.warn("DynamicEntityQuery failed to add path [{}] to query [{}]", path, (Object)this.queryName);
            }
        });
        return root;
    }

    private void resolvePath(ResponseTreeNode node, IntrospectionQuery.Type parentType, List<String> path, Context context) {
        String segment = path.get(0);
        Optional<IntrospectionQuery.Field> fieldLookup = GraphQLIntrospectionUtils.getField(parentType, segment);
        if (!fieldLookup.isPresent()) {
            if (GraphQLIntrospectionUtils.getField(parentType, "edges").isPresent()) {
                this.resolvePath(node, parentType, (List<String>)ImmutableList.builder().add((Object)"edges").addAll(path).build(), context);
                if (GraphQLIntrospectionUtils.getField(parentType, "pageInfo").isPresent()) {
                    this.resolvePath(node, parentType, (List<String>)ImmutableList.builder().add((Object)"pageInfo").add((Object)"hasNextPage").build(), context);
                    this.resolvePath(node, parentType, (List<String>)ImmutableList.builder().add((Object)"pageInfo").add((Object)"hasPreviousPage").build(), context);
                }
                return;
            }
            if (StringUtils.isNumeric((CharSequence)segment) || segment.equals("first") || segment.equals("last")) {
                this.resolvePath(node, parentType, path.subList(1, path.size()), context);
                return;
            }
            if (GraphQLIntrospectionUtils.getField(parentType, "node").isPresent()) {
                this.resolvePath(node, parentType, (List<String>)ImmutableList.builder().add((Object)"node").addAll(path).build(), context);
                if (GraphQLIntrospectionUtils.getField(parentType, "cursor").isPresent()) {
                    node.getChildren().put("cursor", new ResponseTreeNode());
                }
                return;
            }
            if (segment.equals("byName")) {
                node.children.put("name", new ResponseTreeNode());
                node.children.put("type", new ResponseTreeNode());
                node.children.put("value", new ResponseTreeNode());
                return;
            }
        }
        if (!fieldLookup.isPresent()) {
            throw new RuntimeException("bad path segment: " + segment);
        }
        Optional<IntrospectionQuery.Type> typeLookup = GraphQLIntrospectionUtils.getResponseTypeForField(context, fieldLookup.get());
        if (!typeLookup.isPresent()) {
            throw new RuntimeException("bad type for field: " + path);
        }
        IntrospectionQuery.Type type = typeLookup.get();
        ResponseTreeNode nextNode = node.getChildren().get(segment);
        if (nextNode == null) {
            nextNode = new ResponseTreeNode();
        }
        if (path.size() > 1) {
            this.resolvePath(nextNode, type, path.subList(1, path.size()), context);
        }
        node.getChildren().put(segment, nextNode);
    }

    private DynamicDataTypes.QueryDynamicVariables resolveVariablesForQuery(String query, List<GraphQLIntrospectionUtils.CollectedQueryParameter> collectedQueryParams, Context context) {
        HashMap derivedVariables = new HashMap();
        collectedQueryParams.forEach(collectedQueryParameter -> derivedVariables.put(collectedQueryParameter.getAlias(), collectedQueryParameter.getValue()));
        List<GraphQLIntrospectionUtils.QueryParameter> fields = GraphQLIntrospectionUtils.getArgsForQuery(context, query);
        fields.stream().filter(p -> {
            String argPath = query + "." + p.getName();
            boolean isArgumentInQueryParams = collectedQueryParams.stream().anyMatch(collectedQueryParameter -> StringUtils.equals((CharSequence)argPath, (CharSequence)collectedQueryParameter.getPath()));
            return (p.isRequired() || p.getName().equals("id")) && !isArgumentInQueryParams;
        }).map(p -> this.mapParameter((GraphQLIntrospectionUtils.QueryParameter)p, context)).forEach(e -> derivedVariables.put(e.getKey(), e.getValue()));
        return new DynamicDataTypes.QueryDynamicVariables((Map<String, Object>)ImmutableMap.copyOf(derivedVariables));
    }

    private Map.Entry<String, Object> mapParameter(GraphQLIntrospectionUtils.QueryParameter param, Context context) {
        String name = param.getName();
        Event event = context.getEvent();
        Entity entity = context.getEntity();
        switch (name) {
            case "ref": {
                return new AbstractMap.SimpleEntry<String, Object>(name, entity.getRef());
            }
            case "id": {
                return new AbstractMap.SimpleEntry<String, Object>(name, entity.getId());
            }
            case "retailer": {
                return new AbstractMap.SimpleEntry<String, ImmutableMap>(name, ImmutableMap.of((Object)"id", (Object)event.getRetailerId()));
            }
            case "catalogue": {
                return new AbstractMap.SimpleEntry<String, ImmutableMap>(name, ImmutableMap.of((Object)"ref", (Object)event.getRootEntityRef()));
            }
            case "returnOrder": {
                return new AbstractMap.SimpleEntry<String, ImmutableMap>(name, ImmutableMap.of((Object)"ref", (Object)event.getRootEntityRef(), (Object)"retailer", (Object)ImmutableMap.of((Object)"id", (Object)event.getRetailerId())));
            }
        }
        throw new RuntimeException("Cannot build a dynamic query with parameter: " + name);
    }

    public String queryDocument() {
        return this.fullQueryString;
    }

    public DynamicDataTypes.QueryDynamicVariables variables() {
        return this.dynamicVariables;
    }

    public ResponseFieldMapper<DynamicDataTypes.QueryDynamicData> responseFieldMapper() {
        return readerOuter -> {
            try {
                ObjectNode node = (ObjectNode)JsonUtils.stringToNode(readerOuter.readCustomType(ResponseField.forCustomType((String)RESPONSE_ALIAS, (String)RESPONSE_ALIAS, null, (boolean)false, (ScalarType)CustomType.JSON, null)).toString());
                return new DynamicDataTypes.QueryDynamicData(node);
            }
            catch (Exception e) {
                log.error("Exception marshalling DynamicEntityQuery response", (Throwable)e);
                throw new RuntimeException("Exception marshalling DynamicEntityQuery response");
            }
        };
    }

    public DynamicDataTypes.QueryDynamicData wrapData(DynamicDataTypes.QueryDynamicData data) {
        return data;
    }

    @Nonnull
    public OperationName name() {
        return this.name;
    }

    @Nonnull
    public String operationId() {
        return UUID.randomUUID().toString();
    }

    private static final class ResponseTreeNode {
        Map<String, ResponseTreeNode> children = new HashMap<String, ResponseTreeNode>();

        private String toQueryFragment(List<String> path, Context context, List<GraphQLIntrospectionUtils.CollectedQueryParameter> parameters) {
            if (this.children.isEmpty()) {
                return "";
            }
            String childString = this.children.entrySet().stream().map(e -> {
                if (StringUtils.equals((CharSequence)((CharSequence)e.getKey()), (CharSequence)"edges") || StringUtils.equals((CharSequence)((CharSequence)e.getKey()), (CharSequence)"node") || StringUtils.equals((CharSequence)((CharSequence)e.getKey()), (CharSequence)"pageInfo")) {
                    return (String)e.getKey() + ((ResponseTreeNode)e.getValue()).toQueryFragment(path, context, parameters);
                }
                ImmutableList newPath = ImmutableList.builder().addAll((Iterable)path).add(e.getKey()).build();
                return this.toSubQuery((String)e.getKey(), path, context, parameters) + ((ResponseTreeNode)e.getValue()).toQueryFragment((List<String>)newPath, context, parameters);
            }).collect(Collectors.joining(" "));
            return String.format(" { __typename %s }", childString);
        }

        private String toSubQuery(String nextSegment, List<String> path, Context context, List<GraphQLIntrospectionUtils.CollectedQueryParameter> parameters) {
            if (context == null || path == null || parameters == null) {
                return nextSegment;
            }
            String stringPath = String.join((CharSequence)".", path);
            String fullSubQueryPath = StringUtils.isEmpty((CharSequence)stringPath) ? nextSegment : stringPath + "." + nextSegment;
            List<GraphQLIntrospectionUtils.QueryParameter> queryArgs = GraphQLIntrospectionUtils.getArgsForQuery(context, fullSubQueryPath);
            if (queryArgs == null) {
                return nextSegment;
            }
            ArrayList filledQueryArgs = new ArrayList();
            queryArgs.forEach(arg -> {
                String parameterNamePath = fullSubQueryPath + "." + arg.getName();
                List<IntrospectionQuery.InputField> fields = GraphQLIntrospectionUtils.getFieldsForInput(context, arg.getType());
                if (fields != null && !fields.isEmpty()) {
                    ArrayList objectFields = new ArrayList();
                    fields.forEach(field -> {
                        String pathWithinInputObject = parameterNamePath + "." + field.name();
                        parameters.stream().filter(collectedQueryParameter -> StringUtils.equals((CharSequence)collectedQueryParameter.getPath(), (CharSequence)pathWithinInputObject)).findFirst().ifPresent(collectedQueryParameter -> objectFields.add(String.format(DynamicEntityQuery.ARG_VAL_PATTERN, field.name(), collectedQueryParameter.getAlias())));
                    });
                    if (!objectFields.isEmpty()) {
                        filledQueryArgs.add(String.format(DynamicEntityQuery.ARG_OBJECT_VAL_PATTERN, arg.getName(), String.join((CharSequence)", ", objectFields)));
                    }
                } else {
                    parameters.stream().filter(collectedQueryParameter -> StringUtils.equals((CharSequence)collectedQueryParameter.getPath(), (CharSequence)parameterNamePath)).findFirst().ifPresent(collectedQueryParameter -> filledQueryArgs.add(String.format(DynamicEntityQuery.ARG_VAL_PATTERN, arg.getName(), collectedQueryParameter.getAlias())));
                }
            });
            if (filledQueryArgs.isEmpty()) {
                return nextSegment;
            }
            return String.format("%s(%s)", nextSegment, String.join((CharSequence)", ", filledQueryArgs));
        }

        @Generated
        public Map<String, ResponseTreeNode> getChildren() {
            return this.children;
        }

        @Generated
        public void setChildren(Map<String, ResponseTreeNode> children) {
            this.children = children;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResponseTreeNode)) {
                return false;
            }
            ResponseTreeNode other = (ResponseTreeNode)o;
            Map<String, ResponseTreeNode> this$children = this.getChildren();
            Map<String, ResponseTreeNode> other$children = other.getChildren();
            return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, ResponseTreeNode> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DynamicEntityQuery.ResponseTreeNode(children=" + this.getChildren() + ")";
        }

        @Generated
        public ResponseTreeNode() {
        }
    }
}

