/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.dynamic.graphql;

import com.apollographql.apollo.api.Query;
import com.fasterxml.jackson.databind.JavaType;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.dynamic.graphql.DynamicDataTypes;
import com.fluentcommerce.util.dynamic.graphql.DynamicEntityQuery;
import com.fluentcommerce.util.dynamic.graphql.GraphQLIntrospectionUtils;
import com.fluentcommerce.util.dynamic.types.Connection;
import com.fluentretail.rubix.v2.context.Context;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;

public class DynamicConnectionQuery<T>
implements Iterable<T> {
    private final List<Connection<T>> pages = new LinkedList<Connection<T>>();
    private final Context context;
    private final String pathToConnection;
    private final String queryName;
    private final List<String> fieldsPaths;
    private final Class<T> type;
    private final Map<String, Object> params;
    private final int pageLimit;

    public DynamicConnectionQuery(Context context, String queryName, String pathToConnection, Class<T> responseType, Map<String, Object> params) {
        this(context, queryName, pathToConnection, GraphQLIntrospectionUtils.deriveFieldsFromJSON(JsonUtils.getSchemaForClass(responseType), pathToConnection), responseType, params, 100, 1000);
    }

    public DynamicConnectionQuery(Context context, String queryName, String pathToConnection, List<String> fieldsPaths, Class<T> responseType, Map<String, Object> params) {
        this(context, queryName, pathToConnection, fieldsPaths, responseType, params, 100, 1000);
    }

    public DynamicConnectionQuery(Context context, String queryName, String pathToConnection, List<String> connectionFieldsPaths, Class<T> responseType, Map<String, Object> params, int pageLimit, int pageSize) {
        this.context = context;
        this.pathToConnection = pathToConnection;
        this.fieldsPaths = connectionFieldsPaths;
        this.type = responseType;
        this.queryName = queryName;
        this.pageLimit = pageLimit;
        this.params = params == null ? new HashMap<String, Object>() : params;
        this.params.put(pathToConnection + "." + "first", pageSize);
        Optional<Connection<Connection>> firstPage = this.loadPage(null);
        firstPage.ifPresent(this.pages::add);
    }

    private Optional<Connection<T>> loadPage(String cursorAfter) {
        if (StringUtils.isNotEmpty((CharSequence)cursorAfter)) {
            this.params.put(this.pathToConnection + "." + "after", cursorAfter);
        }
        if (this.pages.size() < this.pageLimit) {
            JavaType type = JsonUtils.constructParametricType(Connection.class, this.type);
            Connection page = (Connection)((DynamicDataTypes.QueryDynamicData)this.context.api().query((Query)new DynamicEntityQuery(this.context, this.fieldsPaths, this.queryName, this.params))).as(type, this.pathToConnection);
            return Optional.ofNullable(page);
        }
        return Optional.empty();
    }

    @Override
    public ListIterator<T> iterator() {
        return new DynamicConnectionQueryIterator();
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    private final class DynamicConnectionQueryIterator
    implements ListIterator<T> {
        private int page = 0;
        private int index = 0;

        private DynamicConnectionQueryIterator() {
        }

        @Override
        public boolean hasNext() {
            if (DynamicConnectionQuery.this.pages.isEmpty()) {
                return Boolean.FALSE;
            }
            Connection thisPage = (Connection)DynamicConnectionQuery.this.pages.get(this.page);
            if (this.isEmptyPage(thisPage)) {
                return false;
            }
            return this.index < thisPage.getEdges().size() || thisPage.getPageInfo().isHasNextPage();
        }

        @Override
        public T next() {
            String lastCursor;
            Optional newPage;
            if (DynamicConnectionQuery.this.pages.isEmpty()) {
                return null;
            }
            Connection thisPage = (Connection)DynamicConnectionQuery.this.pages.get(this.page);
            if (this.isEmptyPage(thisPage)) {
                return null;
            }
            if (this.index < thisPage.getEdges().size()) {
                return thisPage.getEdges().get(this.index++).getNode();
            }
            if (this.page + 1 < DynamicConnectionQuery.this.pages.size()) {
                this.index = 0;
                Connection newPage2 = (Connection)DynamicConnectionQuery.this.pages.get(this.page);
                return newPage2.getEdges().get(this.index).getNode();
            }
            if (thisPage.getPageInfo().isHasNextPage() && (newPage = DynamicConnectionQuery.this.loadPage(lastCursor = thisPage.getEdges().get(thisPage.getEdges().size() - 1).getCursor())).isPresent()) {
                this.index = 0;
                ++this.page;
                DynamicConnectionQuery.this.pages.add(newPage.get());
                return ((Connection)newPage.get()).getEdges().get(this.index++).getNode();
            }
            return null;
        }

        @Override
        public boolean hasPrevious() {
            if (DynamicConnectionQuery.this.pages.isEmpty()) {
                return Boolean.FALSE;
            }
            if (this.index - 1 < 0) {
                if (this.page - 1 >= 0) {
                    Connection previousPage = (Connection)DynamicConnectionQuery.this.pages.get(this.page - 1);
                    return !this.isEmptyPage(previousPage);
                }
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        @Override
        public T previous() {
            if (DynamicConnectionQuery.this.pages.isEmpty()) {
                return null;
            }
            if (this.index <= 0) {
                if (this.page - 1 < 0) {
                    return null;
                }
                Connection previousPage = (Connection)DynamicConnectionQuery.this.pages.get(this.page - 1);
                if (this.isEmptyPage(previousPage)) {
                    return null;
                }
                --this.page;
                this.index = previousPage.getEdges().size() - 1;
                return previousPage.getEdges().get(this.index).getNode();
            }
            --this.index;
            return ((Connection)DynamicConnectionQuery.this.pages.get(this.page)).getEdges().get(this.index).getNode();
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException("nextIndex");
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException("previousIndex");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void set(T t) {
            throw new UnsupportedOperationException("set");
        }

        @Override
        public void add(T t) {
            throw new UnsupportedOperationException("add");
        }

        private boolean isEmptyPage(Connection<T> page) {
            return page == null || page.getPageInfo() == null || page.getEdges() == null || page.getEdges().isEmpty();
        }
    }
}

