/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.dynamic;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class JsonUtils {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(mapper);

    public static Map<String, Object> pojoToMap(Object pojo) {
        return (Map)mapper.convertValue(pojo, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static ObjectNode objectToNode(Object obj) {
        return (ObjectNode)mapper.valueToTree(obj);
    }

    public static <T> T anyToPojo(Object unknown, Class<T> type) {
        if (type.isInstance(unknown)) {
            return (T)unknown;
        }
        return (T)mapper.convertValue(unknown, type);
    }

    public static <T> T anyToPojo(Object unknown, JavaType type) {
        if (type.getRawClass().isInstance(unknown)) {
            return (T)unknown;
        }
        return (T)mapper.convertValue(unknown, type);
    }

    public static JsonNode streamToNode(InputStream is) {
        try {
            return mapper.readTree(is);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static JsonNode stringToNode(String json) {
        try {
            return mapper.readTree(json);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static JsonSchema getSchemaForClass(Class type) {
        try {
            return schemaGen.generateSchema(type);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException("Failed to derive schema for class: " + type);
        }
    }

    public static Map<String, JsonSchema> collectAllSchemas(JsonSchema node) {
        HashMap<String, JsonSchema> schemas = new HashMap<String, JsonSchema>();
        if (node.isObjectSchema()) {
            schemas.putIfAbsent(node.getId(), node);
            node.asObjectSchema().getProperties().forEach((key, value) -> {
                if (value.isObjectSchema()) {
                    schemas.putAll(JsonUtils.collectAllSchemas(value));
                } else if (value.isArraySchema()) {
                    schemas.putAll(JsonUtils.collectAllSchemas(value.asArraySchema().getItems().asSingleItems().getSchema()));
                }
            });
        }
        if (node.isArraySchema()) {
            schemas.putAll(JsonUtils.collectAllSchemas(node.asArraySchema().getItems().asSingleItems().getSchema()));
        }
        return schemas;
    }

    public static int intValue(String strNum) {
        try {
            return Integer.parseInt(strNum);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static JsonNode getPath(JsonNode node, String path) {
        String[] splitPath = path.split("\\.");
        JsonNode current = node;
        block0: for (int i = 0; i < splitPath.length; ++i) {
            String idx = splitPath[i];
            if (current.isObject()) {
                if (!current.has(idx)) {
                    if (current.has("edges")) {
                        current = current.get("edges");
                    }
                    if (current.has("node")) {
                        current = current.get("node");
                    }
                }
                if (current.has(idx)) {
                    current = current.get(idx);
                    continue;
                }
                return JsonNodeFactory.instance.nullNode();
            }
            if (!current.isArray()) continue;
            if (current.size() == 0) {
                return JsonNodeFactory.instance.nullNode();
            }
            if ("first".equals(idx)) {
                current = current.get(0);
                continue;
            }
            if ("last".equals(idx)) {
                current = current.get(current.size() - 1);
                continue;
            }
            int arrayIndex = JsonUtils.intValue(splitPath[1]);
            if (arrayIndex > -1 && arrayIndex < current.size()) {
                current = current.get(arrayIndex);
                continue;
            }
            if ("byName".equals(idx)) {
                String attrName = splitPath[++i];
                for (JsonNode attr : current) {
                    if (!attr.has("name") || !attrName.equals(attr.get("name").asText())) continue;
                    current = attr.get("value");
                    continue block0;
                }
                return JsonNodeFactory.instance.nullNode();
            }
            String remainingParts = String.join((CharSequence)".", Arrays.copyOfRange(splitPath, i, splitPath.length));
            return (JsonNode)StreamSupport.stream(current.spliterator(), false).map(item -> JsonUtils.getPath(item, remainingParts)).collect(new ArrayNodeCollector());
        }
        return current;
    }

    public static ImmutableMap<String, JsonNode> flatten(JsonNode node) {
        return JsonUtils.flatten("", node);
    }

    private static ImmutableMap<String, JsonNode> flatten(String path, JsonNode jsonNode) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (jsonNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            String pathPrefix = path.isEmpty() ? "" : path + ".";
            Iterator it = objectNode.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                builder.putAll(JsonUtils.flatten(pathPrefix + (String)entry.getKey(), (JsonNode)entry.getValue()));
            }
        } else if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (int i = 0; i < arrayNode.size(); ++i) {
                if (i == 0) {
                    builder.putAll(JsonUtils.flatten(path + ".first", arrayNode.get(i)));
                }
                builder.putAll(JsonUtils.flatten(path + "." + i, arrayNode.get(i)));
                if (i != arrayNode.size() - 1) continue;
                builder.putAll(JsonUtils.flatten(path + ".last", arrayNode.get(i)));
            }
        } else if (jsonNode.isValueNode()) {
            ValueNode valueNode = (ValueNode)jsonNode;
            builder.put((Object)path, (Object)valueNode);
        }
        return builder.build();
    }

    public static boolean marshallAndEquals(String convertableString, ValueNode node) {
        if (node.isTextual()) {
            return convertableString.equals(node.asText());
        }
        if (node.isInt()) {
            return Integer.valueOf(convertableString).equals(node.asInt());
        }
        if (node.isDouble()) {
            return Double.valueOf(convertableString).equals(node.asDouble());
        }
        if (node.isBoolean()) {
            return Boolean.valueOf(node.asBoolean()).equals(Boolean.valueOf(convertableString));
        }
        if (node.isNull()) {
            return "null".equalsIgnoreCase(convertableString);
        }
        return false;
    }

    public static int marshallAndCompare(String convertableString, ValueNode node) {
        if (node.isTextual()) {
            return convertableString.compareTo(node.asText());
        }
        if (node.isInt()) {
            return Integer.valueOf(convertableString).compareTo(node.asInt());
        }
        if (node.isDouble()) {
            return Double.valueOf(convertableString).compareTo(node.asDouble());
        }
        return 0;
    }

    public static JavaType constructParametricType(Class genericType, Class parameterType) {
        return mapper.getTypeFactory().constructParametricType(genericType, new Class[]{parameterType});
    }

    public static <T> Stream<T> stream(List<T> list) {
        return Optional.ofNullable(list).map(Collection::stream).orElseGet(Stream::empty);
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.registerModules(new Module[]{new GuavaModule()});
    }

    public static final class ArrayNodeCollector
    implements Collector<JsonNode, ArrayNode, ArrayNode> {
        private static final ObjectMapper mapper = new ObjectMapper();

        @Override
        public Supplier<ArrayNode> supplier() {
            return () -> ((ObjectMapper)mapper).createArrayNode();
        }

        @Override
        public BiConsumer<ArrayNode, JsonNode> accumulator() {
            return ArrayNode::add;
        }

        @Override
        public BinaryOperator<ArrayNode> combiner() {
            return (x, y) -> {
                x.addAll(y);
                return x;
            };
        }

        @Override
        public Function<ArrayNode, ArrayNode> finisher() {
            return accumulator -> accumulator;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED);
        }
    }
}

