/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.dynamic;

import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Query;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.dynamic.graphql.DynamicConnectionQuery;
import com.fluentcommerce.util.dynamic.graphql.DynamicDataTypes;
import com.fluentcommerce.util.dynamic.graphql.DynamicEntityQuery;
import com.fluentcommerce.util.dynamic.graphql.DynamicUpdateMutation;
import com.fluentretail.rubix.v2.context.Context;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public class DynamicUtils {
    private static final String EVENT_PREFIX = "event.";

    public static <T> T query(Context context, Class<T> responseType) {
        return ((DynamicDataTypes.QueryDynamicData)context.api().query((Query)new DynamicEntityQuery(context, responseType))).as(responseType);
    }

    public static <T> T query(Context context, Class<T> responseType, Map<String, Object> queryParams) {
        return ((DynamicDataTypes.QueryDynamicData)context.api().query((Query)new DynamicEntityQuery(context, responseType, queryParams))).as(responseType);
    }

    public static <T> Iterable<T> queryList(Context context, String pathToConnection, Class<T> responseType, Map<String, Object> parameters) {
        return new DynamicConnectionQuery<T>(context, null, pathToConnection, responseType, parameters);
    }

    public static <T> Iterable<T> queryList(Context context, String queryName, String pathToConnection, Class<T> responseType, Map<String, Object> parameters) {
        return new DynamicConnectionQuery<T>(context, queryName, pathToConnection, responseType, parameters);
    }

    public static DynamicDataTypes.QueryDynamicData query(Context context, List<String> paths) {
        return (DynamicDataTypes.QueryDynamicData)context.api().query((Query)new DynamicEntityQuery(context, paths));
    }

    public static void mutate(Context context, Map<String, Object> values) {
        context.action().mutation((Mutation)new DynamicUpdateMutation(context, values));
    }

    public static JsonNode getJsonPath(Context context, String jsonPath) {
        if (jsonPath.startsWith(EVENT_PREFIX)) {
            String path = jsonPath.startsWith(EVENT_PREFIX) ? jsonPath.substring(EVENT_PREFIX.length()) : jsonPath;
            ObjectNode node = JsonUtils.objectToNode(context.getEvent());
            JsonNode value = JsonUtils.getPath((JsonNode)node, path);
            if (value.isNull()) {
                value = JsonUtils.getPath((JsonNode)node, "attributes." + path);
            }
            return value;
        }
        return DynamicUtils.query(context, (List<String>)ImmutableList.of((Object)jsonPath)).get(jsonPath);
    }
}

