package com.fluentcommerce.util.dynamic.types;

import lombok.AllArgsConstructor;
import lombok.Value;

import java.util.List;

@Value
@AllArgsConstructor
public class Connection<T> {
    public static final String AFTER = "after";
    public static final String BEFORE = "before";
    public static final String FIRST = "first";
    public static final String LAST = "last";
    public static final int DEFAULT_PAGE_SIZE = 1000;
    public static final int DEFAULT_PAGE_COUNT = 100;

    PageInfo pageInfo;

    List<Node<T>> edges;

    @Value
    @AllArgsConstructor
    public static class Node<T> {
        T node;
        String cursor;
    }

    @Value
    @AllArgsConstructor
    public static class PageInfo {
        boolean hasNextPage;
        boolean hasPreviousPage;
    }
}
