package com.fluentcommerce.util.dynamic.graphql;

import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.google.common.collect.ImmutableMap;
import lombok.Getter;

import java.util.Map;

public class DynamicDataTypes {
    public static class QueryDynamicData implements Operation.Data {
        @Getter
        private final ObjectNode data;

        public <T> T as(Class<T> type) {
            return JsonUtils.anyToPojo(data, type);
        }

        public <T> T as(JavaType type, String path) {
            return JsonUtils.anyToPojo(JsonUtils.getPath(getRoot(), path), type);
        }

        private JsonNode getRoot() {
            // GraphQL results are like `{ data:{ queryname:{ goodstuff } } }` so skip the first two levels
            return ("data".equals(data.fields().next().getKey()))
                    ? data.fields().next().getValue().fields().next().getValue()
                    : data;
        }

        public JsonNode get(String path) {
            return JsonUtils.getPath(getRoot(), path);
        }

        public ImmutableMap<String, JsonNode> flat() {
            return JsonUtils.flatten(getRoot());
        }

        // TODO: give direct access to error block here too?

        public QueryDynamicData(ObjectNode data) { this.data = data; }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return writer -> System.out.println("called Data marshaller: " + writer);
        }
    }

    public final static class QueryDynamicVariables extends Operation.Variables {
        @Getter
        private final Map<String, Object> values;

        public QueryDynamicVariables(Map<String, Object> values) {
            this.values = values;
        }

        public InputFieldMarshaller marshaller() {
            return new DynamicUpdateMutation.MapBasedInputFieldMarshaller(values);
        }
    }

    public final static class MutationOuterData implements Operation.Data {
        @Getter
        private final MutationInnerData inner;

        public MutationOuterData(MutationInnerData inner) { this.inner = inner; }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return writer -> System.out.println("called Data marshaller: " + writer);
        }
    }

    public final static class MutationInnerData implements Operation.Data {
        @Getter private final String __typename;
        @Getter private final String ref;

        public MutationInnerData(String __typename, String ref) {
            this.__typename = __typename;
            this.ref = ref;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return writer -> System.out.println("called Data marshaller: " + writer);
        }
    }

    public final static class MutationDynamicVariables extends Operation.Variables {
        @Getter
        private final Map<String, Object> values;

        public MutationDynamicVariables(Map<String, Object> values) {
            this.values = values;
        }

        @JsonIgnore
        public InputFieldMarshaller marshaller() {
            return new DynamicUpdateMutation.MapBasedInputFieldMarshaller(values);
        }
    }
}
