package com.fluentcommerce.graphql.fragment;

import com.apollographql.apollo.api.FragmentResponseFieldMapper;
import com.apollographql.apollo.api.GraphqlFragment;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.api.internal.Mutator;
import com.apollographql.apollo.api.internal.Utils;
import com.fluentcommerce.graphql.type.__TypeKind;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Generated("Apollo GraphQL")
public class InputValue implements GraphqlFragment {
  static final ResponseField[] $responseFields = {
    ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
    ResponseField.forString("name", "name", null, false, Collections.<ResponseField.Condition>emptyList()),
    ResponseField.forString("description", "description", null, true, Collections.<ResponseField.Condition>emptyList()),
    ResponseField.forObject("type", "type", null, false, Collections.<ResponseField.Condition>emptyList()),
    ResponseField.forString("defaultValue", "defaultValue", null, true, Collections.<ResponseField.Condition>emptyList())
  };

  public static final String FRAGMENT_DEFINITION = "fragment InputValue on __InputValue {\n"
      + "  __typename\n"
      + "  name\n"
      + "  description\n"
      + "  type {\n"
      + "    __typename\n"
      + "    ...TypeRef\n"
      + "  }\n"
      + "  defaultValue\n"
      + "}";

  public static final List<String> POSSIBLE_TYPES = Collections.unmodifiableList(Arrays.asList( "__InputValue"));

  final @Nonnull String __typename;

  final @Nonnull String name;

  final @Nullable String description;

  final @Nonnull Type type;

  final @Nullable String defaultValue;

  private volatile String $toString;

  private volatile int $hashCode;

  private volatile boolean $hashCodeMemoized;

  public InputValue(@Nonnull String __typename, @Nonnull String name, @Nullable String description,
      @Nonnull Type type, @Nullable String defaultValue) {
    this.__typename = Utils.checkNotNull(__typename, "__typename == null");
    this.name = Utils.checkNotNull(name, "name == null");
    this.description = description;
    this.type = Utils.checkNotNull(type, "type == null");
    this.defaultValue = defaultValue;
  }

  public @Nonnull String __typename() {
    return this.__typename;
  }

  public @Nonnull String name() {
    return this.name;
  }

  public @Nullable String description() {
    return this.description;
  }

  public @Nonnull Type type() {
    return this.type;
  }

  /**
   * A GraphQL-formatted string representing the default value for this input value.
   */
  public @Nullable String defaultValue() {
    return this.defaultValue;
  }

  public ResponseFieldMarshaller marshaller() {
    return new ResponseFieldMarshaller() {
      @Override
      public void marshal(ResponseWriter writer) {
        writer.writeString($responseFields[0], __typename);
        writer.writeString($responseFields[1], name);
        writer.writeString($responseFields[2], description);
        writer.writeObject($responseFields[3], type.marshaller());
        writer.writeString($responseFields[4], defaultValue);
      }
    };
  }

  @Override
  public String toString() {
    if ($toString == null) {
      $toString = "InputValue{"
        + "__typename=" + __typename + ", "
        + "name=" + name + ", "
        + "description=" + description + ", "
        + "type=" + type + ", "
        + "defaultValue=" + defaultValue
        + "}";
    }
    return $toString;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof InputValue) {
      InputValue that = (InputValue) o;
      return this.__typename.equals(that.__typename)
       && this.name.equals(that.name)
       && ((this.description == null) ? (that.description == null) : this.description.equals(that.description))
       && this.type.equals(that.type)
       && ((this.defaultValue == null) ? (that.defaultValue == null) : this.defaultValue.equals(that.defaultValue));
    }
    return false;
  }

  @Override
  public int hashCode() {
    if (!$hashCodeMemoized) {
      int h = 1;
      h *= 1000003;
      h ^= __typename.hashCode();
      h *= 1000003;
      h ^= name.hashCode();
      h *= 1000003;
      h ^= (description == null) ? 0 : description.hashCode();
      h *= 1000003;
      h ^= type.hashCode();
      h *= 1000003;
      h ^= (defaultValue == null) ? 0 : defaultValue.hashCode();
      $hashCode = h;
      $hashCodeMemoized = true;
    }
    return $hashCode;
  }

  public Builder toBuilder() {
    Builder builder = new Builder();
    builder.__typename = __typename;
    builder.name = name;
    builder.description = description;
    builder.type = type;
    builder.defaultValue = defaultValue;
    return builder;
  }

  public static Builder builder() {
    return new Builder();
  }

  public static final class Mapper implements ResponseFieldMapper<InputValue> {
    final Type.Mapper typeFieldMapper = new Type.Mapper();

    @Override
    public InputValue map(ResponseReader reader) {
      final String __typename = reader.readString($responseFields[0]);
      final String name = reader.readString($responseFields[1]);
      final String description = reader.readString($responseFields[2]);
      final Type type = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<Type>() {
        @Override
        public Type read(ResponseReader reader) {
          return typeFieldMapper.map(reader);
        }
      });
      final String defaultValue = reader.readString($responseFields[4]);
      return new InputValue(__typename, name, description, type, defaultValue);
    }
  }

  public static class Type {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forFragment("__typename", "__typename", Arrays.asList("__Type"))
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType ofType;

    private final @Nonnull Fragments fragments;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Type(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType ofType, @Nonnull Fragments fragments) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
      this.fragments = Utils.checkNotNull(fragments, "fragments == null");
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType ofType() {
      return this.ofType;
    }

    public @Nonnull Fragments fragments() {
      return this.fragments;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
          fragments.marshaller().marshal(writer);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Type{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType + ", "
          + "fragments=" + fragments
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Type) {
        Type that = (Type) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType))
         && this.fragments.equals(that.fragments);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        h *= 1000003;
        h ^= fragments.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      builder.fragments = fragments;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static class Fragments {
      final @Nonnull TypeRef typeRef;

      private volatile String $toString;

      private volatile int $hashCode;

      private volatile boolean $hashCodeMemoized;

      public Fragments(@Nonnull TypeRef typeRef) {
        this.typeRef = Utils.checkNotNull(typeRef, "typeRef == null");
      }

      public @Nonnull TypeRef typeRef() {
        return this.typeRef;
      }

      public ResponseFieldMarshaller marshaller() {
        return new ResponseFieldMarshaller() {
          @Override
          public void marshal(ResponseWriter writer) {
            final TypeRef $typeRef = typeRef;
            if ($typeRef != null) {
              $typeRef.marshaller().marshal(writer);
            }
          }
        };
      }

      @Override
      public String toString() {
        if ($toString == null) {
          $toString = "Fragments{"
            + "typeRef=" + typeRef
            + "}";
        }
        return $toString;
      }

      @Override
      public boolean equals(Object o) {
        if (o == this) {
          return true;
        }
        if (o instanceof Fragments) {
          Fragments that = (Fragments) o;
          return this.typeRef.equals(that.typeRef);
        }
        return false;
      }

      @Override
      public int hashCode() {
        if (!$hashCodeMemoized) {
          int h = 1;
          h *= 1000003;
          h ^= typeRef.hashCode();
          $hashCode = h;
          $hashCodeMemoized = true;
        }
        return $hashCode;
      }

      public Builder toBuilder() {
        Builder builder = new Builder();
        builder.typeRef = typeRef;
        return builder;
      }

      public static Builder builder() {
        return new Builder();
      }

      public static final class Mapper implements FragmentResponseFieldMapper<Fragments> {
        final TypeRef.Mapper typeRefFieldMapper = new TypeRef.Mapper();

        @Override
        public @Nonnull Fragments map(ResponseReader reader, @Nonnull String conditionalType) {
          TypeRef typeRef = null;
          if (TypeRef.POSSIBLE_TYPES.contains(conditionalType)) {
            typeRef = typeRefFieldMapper.map(reader);
          }
          return new Fragments(Utils.checkNotNull(typeRef, "typeRef == null"));
        }
      }

      public static final class Builder {
        private @Nonnull TypeRef typeRef;

        Builder() {
        }

        public Builder typeRef(@Nonnull TypeRef typeRef) {
          this.typeRef = typeRef;
          return this;
        }

        public Fragments build() {
          Utils.checkNotNull(typeRef, "typeRef == null");
          return new Fragments(typeRef);
        }
      }
    }

    public static final class Mapper implements ResponseFieldMapper<Type> {
      final OfType.Mapper ofTypeFieldMapper = new OfType.Mapper();

      final Fragments.Mapper fragmentsFieldMapper = new Fragments.Mapper();

      @Override
      public Type map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType>() {
          @Override
          public OfType read(ResponseReader reader) {
            return ofTypeFieldMapper.map(reader);
          }
        });
        final Fragments fragments = reader.readConditional($responseFields[4], new ResponseReader.ConditionalTypeReader<Fragments>() {
          @Override
          public Fragments read(String conditionalType, ResponseReader reader) {
            return fragmentsFieldMapper.map(reader, conditionalType);
          }
        });
        return new Type(__typename, kind, name, ofType, fragments);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType ofType;

      private @Nonnull Fragments fragments;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder fragments(@Nonnull Fragments fragments) {
        this.fragments = fragments;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public Builder fragments(@Nonnull Mutator<Fragments.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Fragments.Builder builder = this.fragments != null ? this.fragments.toBuilder() : Fragments.builder();
        mutator.accept(builder);
        this.fragments = builder.build();
        return this;
      }

      public Type build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        Utils.checkNotNull(fragments, "fragments == null");
        return new Type(__typename, kind, name, ofType, fragments);
      }
    }
  }

  public static class OfType {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType1 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType1 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType1 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType) {
        OfType that = (OfType) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType> {
      final OfType1.Mapper ofType1FieldMapper = new OfType1.Mapper();

      @Override
      public OfType map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType1 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType1>() {
          @Override
          public OfType1 read(ResponseReader reader) {
            return ofType1FieldMapper.map(reader);
          }
        });
        return new OfType(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType1 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType1 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType1.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType1.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType1.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType1 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType2 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType1(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType2 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType2 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType1{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType1) {
        OfType1 that = (OfType1) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType1> {
      final OfType2.Mapper ofType2FieldMapper = new OfType2.Mapper();

      @Override
      public OfType1 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType2 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType2>() {
          @Override
          public OfType2 read(ResponseReader reader) {
            return ofType2FieldMapper.map(reader);
          }
        });
        return new OfType1(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType2 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType2 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType2.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType2.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType2.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType1 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType1(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType2 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType3 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType2(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType3 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType3 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType2{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType2) {
        OfType2 that = (OfType2) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType2> {
      final OfType3.Mapper ofType3FieldMapper = new OfType3.Mapper();

      @Override
      public OfType2 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType3 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType3>() {
          @Override
          public OfType3 read(ResponseReader reader) {
            return ofType3FieldMapper.map(reader);
          }
        });
        return new OfType2(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType3 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType3 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType3.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType3.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType3.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType2 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType2(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType3 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType3(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType3{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType3) {
        OfType3 that = (OfType3) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType3> {
      @Override
      public OfType3 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        return new OfType3(__typename, kind, name);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public OfType3 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType3(__typename, kind, name);
      }
    }
  }

  public static final class Builder {
    private @Nonnull String __typename;

    private @Nonnull String name;

    private @Nullable String description;

    private @Nonnull Type type;

    private @Nullable String defaultValue;

    Builder() {
    }

    public Builder __typename(@Nonnull String __typename) {
      this.__typename = __typename;
      return this;
    }

    public Builder name(@Nonnull String name) {
      this.name = name;
      return this;
    }

    public Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    public Builder type(@Nonnull Type type) {
      this.type = type;
      return this;
    }

    public Builder defaultValue(@Nullable String defaultValue) {
      this.defaultValue = defaultValue;
      return this;
    }

    public Builder type(@Nonnull Mutator<Type.Builder> mutator) {
      Utils.checkNotNull(mutator, "mutator == null");
      Type.Builder builder = this.type != null ? this.type.toBuilder() : Type.builder();
      mutator.accept(builder);
      this.type = builder.build();
      return this;
    }

    public InputValue build() {
      Utils.checkNotNull(__typename, "__typename == null");
      Utils.checkNotNull(name, "name == null");
      Utils.checkNotNull(type, "type == null");
      return new InputValue(__typename, name, description, type, defaultValue);
    }
  }
}
