package com.fluentcommerce.graphql.fragment;

import com.apollographql.apollo.api.FragmentResponseFieldMapper;
import com.apollographql.apollo.api.GraphqlFragment;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.api.internal.Mutator;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.fluentcommerce.graphql.type.__TypeKind;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Generated("Apollo GraphQL")
public class FullType implements GraphqlFragment {
  static final ResponseField[] $responseFields = {
    ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
    ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
    ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
    ResponseField.forString("description", "description", null, true, Collections.<ResponseField.Condition>emptyList()),
    ResponseField.forList("fields", "fields", new UnmodifiableMapBuilder<String, Object>(1)
      .put("includeDeprecated", "true")
    .build(), true, Collections.<ResponseField.Condition>emptyList()),
    ResponseField.forList("inputFields", "inputFields", null, true, Collections.<ResponseField.Condition>emptyList()),
    ResponseField.forList("interfaces", "interfaces", null, true, Collections.<ResponseField.Condition>emptyList()),
    ResponseField.forList("enumValues", "enumValues", new UnmodifiableMapBuilder<String, Object>(1)
      .put("includeDeprecated", "true")
    .build(), true, Collections.<ResponseField.Condition>emptyList()),
    ResponseField.forList("possibleTypes", "possibleTypes", null, true, Collections.<ResponseField.Condition>emptyList())
  };

  public static final String FRAGMENT_DEFINITION = "fragment FullType on __Type {\n"
      + "  __typename\n"
      + "  kind\n"
      + "  name\n"
      + "  description\n"
      + "  fields(includeDeprecated: true) {\n"
      + "    __typename\n"
      + "    name\n"
      + "    description\n"
      + "    args {\n"
      + "      __typename\n"
      + "      ...InputValue\n"
      + "    }\n"
      + "    type {\n"
      + "      __typename\n"
      + "      ...TypeRef\n"
      + "    }\n"
      + "    isDeprecated\n"
      + "    deprecationReason\n"
      + "  }\n"
      + "  inputFields {\n"
      + "    __typename\n"
      + "    ...InputValue\n"
      + "  }\n"
      + "  interfaces {\n"
      + "    __typename\n"
      + "    ...TypeRef\n"
      + "  }\n"
      + "  enumValues(includeDeprecated: true) {\n"
      + "    __typename\n"
      + "    name\n"
      + "    description\n"
      + "    isDeprecated\n"
      + "    deprecationReason\n"
      + "  }\n"
      + "  possibleTypes {\n"
      + "    __typename\n"
      + "    ...TypeRef\n"
      + "  }\n"
      + "}";

  public static final List<String> POSSIBLE_TYPES = Collections.unmodifiableList(Arrays.asList( "__Type"));

  final @Nonnull String __typename;

  final @Nonnull __TypeKind kind;

  final @Nullable String name;

  final @Nullable String description;

  final @Nullable List<Field> fields;

  final @Nullable List<InputField> inputFields;

  final @Nullable List<Interface> interfaces;

  final @Nullable List<EnumValue> enumValues;

  final @Nullable List<PossibleType> possibleTypes;

  private volatile String $toString;

  private volatile int $hashCode;

  private volatile boolean $hashCodeMemoized;

  public FullType(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
      @Nullable String description, @Nullable List<Field> fields,
      @Nullable List<InputField> inputFields, @Nullable List<Interface> interfaces,
      @Nullable List<EnumValue> enumValues, @Nullable List<PossibleType> possibleTypes) {
    this.__typename = Utils.checkNotNull(__typename, "__typename == null");
    this.kind = Utils.checkNotNull(kind, "kind == null");
    this.name = name;
    this.description = description;
    this.fields = fields;
    this.inputFields = inputFields;
    this.interfaces = interfaces;
    this.enumValues = enumValues;
    this.possibleTypes = possibleTypes;
  }

  public @Nonnull String __typename() {
    return this.__typename;
  }

  public @Nonnull __TypeKind kind() {
    return this.kind;
  }

  public @Nullable String name() {
    return this.name;
  }

  public @Nullable String description() {
    return this.description;
  }

  public @Nullable List<Field> fields() {
    return this.fields;
  }

  public @Nullable List<InputField> inputFields() {
    return this.inputFields;
  }

  public @Nullable List<Interface> interfaces() {
    return this.interfaces;
  }

  public @Nullable List<EnumValue> enumValues() {
    return this.enumValues;
  }

  public @Nullable List<PossibleType> possibleTypes() {
    return this.possibleTypes;
  }

  public ResponseFieldMarshaller marshaller() {
    return new ResponseFieldMarshaller() {
      @Override
      public void marshal(ResponseWriter writer) {
        writer.writeString($responseFields[0], __typename);
        writer.writeString($responseFields[1], kind.name());
        writer.writeString($responseFields[2], name);
        writer.writeString($responseFields[3], description);
        writer.writeList($responseFields[4], fields, new ResponseWriter.ListWriter() {
          @Override
          public void write(Object value, ResponseWriter.ListItemWriter listItemWriter) {
            listItemWriter.writeObject(((Field) value).marshaller());
          }
        });
        writer.writeList($responseFields[5], inputFields, new ResponseWriter.ListWriter() {
          @Override
          public void write(Object value, ResponseWriter.ListItemWriter listItemWriter) {
            listItemWriter.writeObject(((InputField) value).marshaller());
          }
        });
        writer.writeList($responseFields[6], interfaces, new ResponseWriter.ListWriter() {
          @Override
          public void write(Object value, ResponseWriter.ListItemWriter listItemWriter) {
            listItemWriter.writeObject(((Interface) value).marshaller());
          }
        });
        writer.writeList($responseFields[7], enumValues, new ResponseWriter.ListWriter() {
          @Override
          public void write(Object value, ResponseWriter.ListItemWriter listItemWriter) {
            listItemWriter.writeObject(((EnumValue) value).marshaller());
          }
        });
        writer.writeList($responseFields[8], possibleTypes, new ResponseWriter.ListWriter() {
          @Override
          public void write(Object value, ResponseWriter.ListItemWriter listItemWriter) {
            listItemWriter.writeObject(((PossibleType) value).marshaller());
          }
        });
      }
    };
  }

  @Override
  public String toString() {
    if ($toString == null) {
      $toString = "FullType{"
        + "__typename=" + __typename + ", "
        + "kind=" + kind + ", "
        + "name=" + name + ", "
        + "description=" + description + ", "
        + "fields=" + fields + ", "
        + "inputFields=" + inputFields + ", "
        + "interfaces=" + interfaces + ", "
        + "enumValues=" + enumValues + ", "
        + "possibleTypes=" + possibleTypes
        + "}";
    }
    return $toString;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FullType) {
      FullType that = (FullType) o;
      return this.__typename.equals(that.__typename)
       && this.kind.equals(that.kind)
       && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
       && ((this.description == null) ? (that.description == null) : this.description.equals(that.description))
       && ((this.fields == null) ? (that.fields == null) : this.fields.equals(that.fields))
       && ((this.inputFields == null) ? (that.inputFields == null) : this.inputFields.equals(that.inputFields))
       && ((this.interfaces == null) ? (that.interfaces == null) : this.interfaces.equals(that.interfaces))
       && ((this.enumValues == null) ? (that.enumValues == null) : this.enumValues.equals(that.enumValues))
       && ((this.possibleTypes == null) ? (that.possibleTypes == null) : this.possibleTypes.equals(that.possibleTypes));
    }
    return false;
  }

  @Override
  public int hashCode() {
    if (!$hashCodeMemoized) {
      int h = 1;
      h *= 1000003;
      h ^= __typename.hashCode();
      h *= 1000003;
      h ^= kind.hashCode();
      h *= 1000003;
      h ^= (name == null) ? 0 : name.hashCode();
      h *= 1000003;
      h ^= (description == null) ? 0 : description.hashCode();
      h *= 1000003;
      h ^= (fields == null) ? 0 : fields.hashCode();
      h *= 1000003;
      h ^= (inputFields == null) ? 0 : inputFields.hashCode();
      h *= 1000003;
      h ^= (interfaces == null) ? 0 : interfaces.hashCode();
      h *= 1000003;
      h ^= (enumValues == null) ? 0 : enumValues.hashCode();
      h *= 1000003;
      h ^= (possibleTypes == null) ? 0 : possibleTypes.hashCode();
      $hashCode = h;
      $hashCodeMemoized = true;
    }
    return $hashCode;
  }

  public Builder toBuilder() {
    Builder builder = new Builder();
    builder.__typename = __typename;
    builder.kind = kind;
    builder.name = name;
    builder.description = description;
    builder.fields = fields;
    builder.inputFields = inputFields;
    builder.interfaces = interfaces;
    builder.enumValues = enumValues;
    builder.possibleTypes = possibleTypes;
    return builder;
  }

  public static Builder builder() {
    return new Builder();
  }

  public static final class Mapper implements ResponseFieldMapper<FullType> {
    final Field.Mapper fieldFieldMapper = new Field.Mapper();

    final InputField.Mapper inputFieldFieldMapper = new InputField.Mapper();

    final Interface.Mapper interfaceFieldMapper = new Interface.Mapper();

    final EnumValue.Mapper enumValueFieldMapper = new EnumValue.Mapper();

    final PossibleType.Mapper possibleTypeFieldMapper = new PossibleType.Mapper();

    @Override
    public FullType map(ResponseReader reader) {
      final String __typename = reader.readString($responseFields[0]);
      final String kindStr = reader.readString($responseFields[1]);
      final __TypeKind kind;
      if (kindStr != null) {
        kind = __TypeKind.valueOf(kindStr);
      } else {
        kind = null;
      }
      final String name = reader.readString($responseFields[2]);
      final String description = reader.readString($responseFields[3]);
      final List<Field> fields = reader.readList($responseFields[4], new ResponseReader.ListReader<Field>() {
        @Override
        public Field read(ResponseReader.ListItemReader listItemReader) {
          return listItemReader.readObject(new ResponseReader.ObjectReader<Field>() {
            @Override
            public Field read(ResponseReader reader) {
              return fieldFieldMapper.map(reader);
            }
          });
        }
      });
      final List<InputField> inputFields = reader.readList($responseFields[5], new ResponseReader.ListReader<InputField>() {
        @Override
        public InputField read(ResponseReader.ListItemReader listItemReader) {
          return listItemReader.readObject(new ResponseReader.ObjectReader<InputField>() {
            @Override
            public InputField read(ResponseReader reader) {
              return inputFieldFieldMapper.map(reader);
            }
          });
        }
      });
      final List<Interface> interfaces = reader.readList($responseFields[6], new ResponseReader.ListReader<Interface>() {
        @Override
        public Interface read(ResponseReader.ListItemReader listItemReader) {
          return listItemReader.readObject(new ResponseReader.ObjectReader<Interface>() {
            @Override
            public Interface read(ResponseReader reader) {
              return interfaceFieldMapper.map(reader);
            }
          });
        }
      });
      final List<EnumValue> enumValues = reader.readList($responseFields[7], new ResponseReader.ListReader<EnumValue>() {
        @Override
        public EnumValue read(ResponseReader.ListItemReader listItemReader) {
          return listItemReader.readObject(new ResponseReader.ObjectReader<EnumValue>() {
            @Override
            public EnumValue read(ResponseReader reader) {
              return enumValueFieldMapper.map(reader);
            }
          });
        }
      });
      final List<PossibleType> possibleTypes = reader.readList($responseFields[8], new ResponseReader.ListReader<PossibleType>() {
        @Override
        public PossibleType read(ResponseReader.ListItemReader listItemReader) {
          return listItemReader.readObject(new ResponseReader.ObjectReader<PossibleType>() {
            @Override
            public PossibleType read(ResponseReader reader) {
              return possibleTypeFieldMapper.map(reader);
            }
          });
        }
      });
      return new FullType(__typename, kind, name, description, fields, inputFields, interfaces, enumValues, possibleTypes);
    }
  }

  public static class Field {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("description", "description", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forList("args", "args", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("type", "type", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forBoolean("isDeprecated", "isDeprecated", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("deprecationReason", "deprecationReason", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull String name;

    final @Nullable String description;

    final @Nonnull List<Arg> args;

    final @Nonnull Type1 type;

    final boolean isDeprecated;

    final @Nullable String deprecationReason;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Field(@Nonnull String __typename, @Nonnull String name, @Nullable String description,
        @Nonnull List<Arg> args, @Nonnull Type1 type, boolean isDeprecated,
        @Nullable String deprecationReason) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.name = Utils.checkNotNull(name, "name == null");
      this.description = description;
      this.args = Utils.checkNotNull(args, "args == null");
      this.type = Utils.checkNotNull(type, "type == null");
      this.isDeprecated = isDeprecated;
      this.deprecationReason = deprecationReason;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull String name() {
      return this.name;
    }

    public @Nullable String description() {
      return this.description;
    }

    public @Nonnull List<Arg> args() {
      return this.args;
    }

    public @Nonnull Type1 type() {
      return this.type;
    }

    public boolean isDeprecated() {
      return this.isDeprecated;
    }

    public @Nullable String deprecationReason() {
      return this.deprecationReason;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], name);
          writer.writeString($responseFields[2], description);
          writer.writeList($responseFields[3], args, new ResponseWriter.ListWriter() {
            @Override
            public void write(Object value, ResponseWriter.ListItemWriter listItemWriter) {
              listItemWriter.writeObject(((Arg) value).marshaller());
            }
          });
          writer.writeObject($responseFields[4], type.marshaller());
          writer.writeBoolean($responseFields[5], isDeprecated);
          writer.writeString($responseFields[6], deprecationReason);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Field{"
          + "__typename=" + __typename + ", "
          + "name=" + name + ", "
          + "description=" + description + ", "
          + "args=" + args + ", "
          + "type=" + type + ", "
          + "isDeprecated=" + isDeprecated + ", "
          + "deprecationReason=" + deprecationReason
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Field) {
        Field that = (Field) o;
        return this.__typename.equals(that.__typename)
         && this.name.equals(that.name)
         && ((this.description == null) ? (that.description == null) : this.description.equals(that.description))
         && this.args.equals(that.args)
         && this.type.equals(that.type)
         && this.isDeprecated == that.isDeprecated
         && ((this.deprecationReason == null) ? (that.deprecationReason == null) : this.deprecationReason.equals(that.deprecationReason));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= name.hashCode();
        h *= 1000003;
        h ^= (description == null) ? 0 : description.hashCode();
        h *= 1000003;
        h ^= args.hashCode();
        h *= 1000003;
        h ^= type.hashCode();
        h *= 1000003;
        h ^= Boolean.valueOf(isDeprecated).hashCode();
        h *= 1000003;
        h ^= (deprecationReason == null) ? 0 : deprecationReason.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.name = name;
      builder.description = description;
      builder.args = args;
      builder.type = type;
      builder.isDeprecated = isDeprecated;
      builder.deprecationReason = deprecationReason;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Field> {
      final Arg.Mapper argFieldMapper = new Arg.Mapper();

      final Type1.Mapper type1FieldMapper = new Type1.Mapper();

      @Override
      public Field map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String name = reader.readString($responseFields[1]);
        final String description = reader.readString($responseFields[2]);
        final List<Arg> args = reader.readList($responseFields[3], new ResponseReader.ListReader<Arg>() {
          @Override
          public Arg read(ResponseReader.ListItemReader listItemReader) {
            return listItemReader.readObject(new ResponseReader.ObjectReader<Arg>() {
              @Override
              public Arg read(ResponseReader reader) {
                return argFieldMapper.map(reader);
              }
            });
          }
        });
        final Type1 type = reader.readObject($responseFields[4], new ResponseReader.ObjectReader<Type1>() {
          @Override
          public Type1 read(ResponseReader reader) {
            return type1FieldMapper.map(reader);
          }
        });
        final boolean isDeprecated = reader.readBoolean($responseFields[5]);
        final String deprecationReason = reader.readString($responseFields[6]);
        return new Field(__typename, name, description, args, type, isDeprecated, deprecationReason);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull String name;

      private @Nullable String description;

      private @Nonnull List<Arg> args;

      private @Nonnull Type1 type;

      private boolean isDeprecated;

      private @Nullable String deprecationReason;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder name(@Nonnull String name) {
        this.name = name;
        return this;
      }

      public Builder description(@Nullable String description) {
        this.description = description;
        return this;
      }

      public Builder args(@Nonnull List<Arg> args) {
        this.args = args;
        return this;
      }

      public Builder type(@Nonnull Type1 type) {
        this.type = type;
        return this;
      }

      public Builder isDeprecated(boolean isDeprecated) {
        this.isDeprecated = isDeprecated;
        return this;
      }

      public Builder deprecationReason(@Nullable String deprecationReason) {
        this.deprecationReason = deprecationReason;
        return this;
      }

      public Builder args(@Nonnull Mutator<List<Arg.Builder>> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        List<Arg.Builder> builders = new ArrayList<>();
        if (this.args != null) {
          for (Arg item : this.args) {
            builders.add(item != null ? item.toBuilder() : null);
          }
        }
        mutator.accept(builders);
        List<Arg> args = new ArrayList<>();
        for (Arg.Builder item : builders) {
          args.add(item != null ? item.build() : null);
        }
        this.args = args;
        return this;
      }

      public Builder type(@Nonnull Mutator<Type1.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Type1.Builder builder = this.type != null ? this.type.toBuilder() : Type1.builder();
        mutator.accept(builder);
        this.type = builder.build();
        return this;
      }

      public Field build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(name, "name == null");
        Utils.checkNotNull(args, "args == null");
        Utils.checkNotNull(type, "type == null");
        return new Field(__typename, name, description, args, type, isDeprecated, deprecationReason);
      }
    }
  }

  public static class Arg {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("description", "description", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("type", "type", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("defaultValue", "defaultValue", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forFragment("__typename", "__typename", Arrays.asList("__InputValue"))
    };

    final @Nonnull String __typename;

    final @Nonnull String name;

    final @Nullable String description;

    final @Nonnull Type type;

    final @Nullable String defaultValue;

    private final @Nonnull Fragments fragments;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Arg(@Nonnull String __typename, @Nonnull String name, @Nullable String description,
        @Nonnull Type type, @Nullable String defaultValue, @Nonnull Fragments fragments) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.name = Utils.checkNotNull(name, "name == null");
      this.description = description;
      this.type = Utils.checkNotNull(type, "type == null");
      this.defaultValue = defaultValue;
      this.fragments = Utils.checkNotNull(fragments, "fragments == null");
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull String name() {
      return this.name;
    }

    public @Nullable String description() {
      return this.description;
    }

    public @Nonnull Type type() {
      return this.type;
    }

    /**
     * A GraphQL-formatted string representing the default value for this input value.
     */
    public @Nullable String defaultValue() {
      return this.defaultValue;
    }

    public @Nonnull Fragments fragments() {
      return this.fragments;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], name);
          writer.writeString($responseFields[2], description);
          writer.writeObject($responseFields[3], type.marshaller());
          writer.writeString($responseFields[4], defaultValue);
          fragments.marshaller().marshal(writer);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Arg{"
          + "__typename=" + __typename + ", "
          + "name=" + name + ", "
          + "description=" + description + ", "
          + "type=" + type + ", "
          + "defaultValue=" + defaultValue + ", "
          + "fragments=" + fragments
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Arg) {
        Arg that = (Arg) o;
        return this.__typename.equals(that.__typename)
         && this.name.equals(that.name)
         && ((this.description == null) ? (that.description == null) : this.description.equals(that.description))
         && this.type.equals(that.type)
         && ((this.defaultValue == null) ? (that.defaultValue == null) : this.defaultValue.equals(that.defaultValue))
         && this.fragments.equals(that.fragments);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= name.hashCode();
        h *= 1000003;
        h ^= (description == null) ? 0 : description.hashCode();
        h *= 1000003;
        h ^= type.hashCode();
        h *= 1000003;
        h ^= (defaultValue == null) ? 0 : defaultValue.hashCode();
        h *= 1000003;
        h ^= fragments.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.name = name;
      builder.description = description;
      builder.type = type;
      builder.defaultValue = defaultValue;
      builder.fragments = fragments;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static class Fragments {
      final @Nonnull InputValue inputValue;

      private volatile String $toString;

      private volatile int $hashCode;

      private volatile boolean $hashCodeMemoized;

      public Fragments(@Nonnull InputValue inputValue) {
        this.inputValue = Utils.checkNotNull(inputValue, "inputValue == null");
      }

      public @Nonnull InputValue inputValue() {
        return this.inputValue;
      }

      public ResponseFieldMarshaller marshaller() {
        return new ResponseFieldMarshaller() {
          @Override
          public void marshal(ResponseWriter writer) {
            final InputValue $inputValue = inputValue;
            if ($inputValue != null) {
              $inputValue.marshaller().marshal(writer);
            }
          }
        };
      }

      @Override
      public String toString() {
        if ($toString == null) {
          $toString = "Fragments{"
            + "inputValue=" + inputValue
            + "}";
        }
        return $toString;
      }

      @Override
      public boolean equals(Object o) {
        if (o == this) {
          return true;
        }
        if (o instanceof Fragments) {
          Fragments that = (Fragments) o;
          return this.inputValue.equals(that.inputValue);
        }
        return false;
      }

      @Override
      public int hashCode() {
        if (!$hashCodeMemoized) {
          int h = 1;
          h *= 1000003;
          h ^= inputValue.hashCode();
          $hashCode = h;
          $hashCodeMemoized = true;
        }
        return $hashCode;
      }

      public Builder toBuilder() {
        Builder builder = new Builder();
        builder.inputValue = inputValue;
        return builder;
      }

      public static Builder builder() {
        return new Builder();
      }

      public static final class Mapper implements FragmentResponseFieldMapper<Fragments> {
        final InputValue.Mapper inputValueFieldMapper = new InputValue.Mapper();

        @Override
        public @Nonnull Fragments map(ResponseReader reader, @Nonnull String conditionalType) {
          InputValue inputValue = null;
          if (InputValue.POSSIBLE_TYPES.contains(conditionalType)) {
            inputValue = inputValueFieldMapper.map(reader);
          }
          return new Fragments(Utils.checkNotNull(inputValue, "inputValue == null"));
        }
      }

      public static final class Builder {
        private @Nonnull InputValue inputValue;

        Builder() {
        }

        public Builder inputValue(@Nonnull InputValue inputValue) {
          this.inputValue = inputValue;
          return this;
        }

        public Fragments build() {
          Utils.checkNotNull(inputValue, "inputValue == null");
          return new Fragments(inputValue);
        }
      }
    }

    public static final class Mapper implements ResponseFieldMapper<Arg> {
      final Type.Mapper typeFieldMapper = new Type.Mapper();

      final Fragments.Mapper fragmentsFieldMapper = new Fragments.Mapper();

      @Override
      public Arg map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String name = reader.readString($responseFields[1]);
        final String description = reader.readString($responseFields[2]);
        final Type type = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<Type>() {
          @Override
          public Type read(ResponseReader reader) {
            return typeFieldMapper.map(reader);
          }
        });
        final String defaultValue = reader.readString($responseFields[4]);
        final Fragments fragments = reader.readConditional($responseFields[5], new ResponseReader.ConditionalTypeReader<Fragments>() {
          @Override
          public Fragments read(String conditionalType, ResponseReader reader) {
            return fragmentsFieldMapper.map(reader, conditionalType);
          }
        });
        return new Arg(__typename, name, description, type, defaultValue, fragments);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull String name;

      private @Nullable String description;

      private @Nonnull Type type;

      private @Nullable String defaultValue;

      private @Nonnull Fragments fragments;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder name(@Nonnull String name) {
        this.name = name;
        return this;
      }

      public Builder description(@Nullable String description) {
        this.description = description;
        return this;
      }

      public Builder type(@Nonnull Type type) {
        this.type = type;
        return this;
      }

      public Builder defaultValue(@Nullable String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
      }

      public Builder fragments(@Nonnull Fragments fragments) {
        this.fragments = fragments;
        return this;
      }

      public Builder type(@Nonnull Mutator<Type.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Type.Builder builder = this.type != null ? this.type.toBuilder() : Type.builder();
        mutator.accept(builder);
        this.type = builder.build();
        return this;
      }

      public Builder fragments(@Nonnull Mutator<Fragments.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Fragments.Builder builder = this.fragments != null ? this.fragments.toBuilder() : Fragments.builder();
        mutator.accept(builder);
        this.fragments = builder.build();
        return this;
      }

      public Arg build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(name, "name == null");
        Utils.checkNotNull(type, "type == null");
        Utils.checkNotNull(fragments, "fragments == null");
        return new Arg(__typename, name, description, type, defaultValue, fragments);
      }
    }
  }

  public static class Type {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forFragment("__typename", "__typename", Arrays.asList("__Type"))
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType ofType;

    private final @Nonnull Fragments fragments;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Type(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType ofType, @Nonnull Fragments fragments) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
      this.fragments = Utils.checkNotNull(fragments, "fragments == null");
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType ofType() {
      return this.ofType;
    }

    public @Nonnull Fragments fragments() {
      return this.fragments;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
          fragments.marshaller().marshal(writer);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Type{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType + ", "
          + "fragments=" + fragments
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Type) {
        Type that = (Type) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType))
         && this.fragments.equals(that.fragments);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        h *= 1000003;
        h ^= fragments.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      builder.fragments = fragments;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static class Fragments {
      final @Nonnull TypeRef typeRef;

      private volatile String $toString;

      private volatile int $hashCode;

      private volatile boolean $hashCodeMemoized;

      public Fragments(@Nonnull TypeRef typeRef) {
        this.typeRef = Utils.checkNotNull(typeRef, "typeRef == null");
      }

      public @Nonnull TypeRef typeRef() {
        return this.typeRef;
      }

      public ResponseFieldMarshaller marshaller() {
        return new ResponseFieldMarshaller() {
          @Override
          public void marshal(ResponseWriter writer) {
            final TypeRef $typeRef = typeRef;
            if ($typeRef != null) {
              $typeRef.marshaller().marshal(writer);
            }
          }
        };
      }

      @Override
      public String toString() {
        if ($toString == null) {
          $toString = "Fragments{"
            + "typeRef=" + typeRef
            + "}";
        }
        return $toString;
      }

      @Override
      public boolean equals(Object o) {
        if (o == this) {
          return true;
        }
        if (o instanceof Fragments) {
          Fragments that = (Fragments) o;
          return this.typeRef.equals(that.typeRef);
        }
        return false;
      }

      @Override
      public int hashCode() {
        if (!$hashCodeMemoized) {
          int h = 1;
          h *= 1000003;
          h ^= typeRef.hashCode();
          $hashCode = h;
          $hashCodeMemoized = true;
        }
        return $hashCode;
      }

      public Builder toBuilder() {
        Builder builder = new Builder();
        builder.typeRef = typeRef;
        return builder;
      }

      public static Builder builder() {
        return new Builder();
      }

      public static final class Mapper implements FragmentResponseFieldMapper<Fragments> {
        final TypeRef.Mapper typeRefFieldMapper = new TypeRef.Mapper();

        @Override
        public @Nonnull Fragments map(ResponseReader reader, @Nonnull String conditionalType) {
          TypeRef typeRef = null;
          if (TypeRef.POSSIBLE_TYPES.contains(conditionalType)) {
            typeRef = typeRefFieldMapper.map(reader);
          }
          return new Fragments(Utils.checkNotNull(typeRef, "typeRef == null"));
        }
      }

      public static final class Builder {
        private @Nonnull TypeRef typeRef;

        Builder() {
        }

        public Builder typeRef(@Nonnull TypeRef typeRef) {
          this.typeRef = typeRef;
          return this;
        }

        public Fragments build() {
          Utils.checkNotNull(typeRef, "typeRef == null");
          return new Fragments(typeRef);
        }
      }
    }

    public static final class Mapper implements ResponseFieldMapper<Type> {
      final OfType.Mapper ofTypeFieldMapper = new OfType.Mapper();

      final Fragments.Mapper fragmentsFieldMapper = new Fragments.Mapper();

      @Override
      public Type map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType>() {
          @Override
          public OfType read(ResponseReader reader) {
            return ofTypeFieldMapper.map(reader);
          }
        });
        final Fragments fragments = reader.readConditional($responseFields[4], new ResponseReader.ConditionalTypeReader<Fragments>() {
          @Override
          public Fragments read(String conditionalType, ResponseReader reader) {
            return fragmentsFieldMapper.map(reader, conditionalType);
          }
        });
        return new Type(__typename, kind, name, ofType, fragments);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType ofType;

      private @Nonnull Fragments fragments;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder fragments(@Nonnull Fragments fragments) {
        this.fragments = fragments;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public Builder fragments(@Nonnull Mutator<Fragments.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Fragments.Builder builder = this.fragments != null ? this.fragments.toBuilder() : Fragments.builder();
        mutator.accept(builder);
        this.fragments = builder.build();
        return this;
      }

      public Type build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        Utils.checkNotNull(fragments, "fragments == null");
        return new Type(__typename, kind, name, ofType, fragments);
      }
    }
  }

  public static class OfType {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType1 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType1 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType1 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType) {
        OfType that = (OfType) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType> {
      final OfType1.Mapper ofType1FieldMapper = new OfType1.Mapper();

      @Override
      public OfType map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType1 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType1>() {
          @Override
          public OfType1 read(ResponseReader reader) {
            return ofType1FieldMapper.map(reader);
          }
        });
        return new OfType(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType1 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType1 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType1.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType1.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType1.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType1 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType2 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType1(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType2 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType2 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType1{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType1) {
        OfType1 that = (OfType1) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType1> {
      final OfType2.Mapper ofType2FieldMapper = new OfType2.Mapper();

      @Override
      public OfType1 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType2 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType2>() {
          @Override
          public OfType2 read(ResponseReader reader) {
            return ofType2FieldMapper.map(reader);
          }
        });
        return new OfType1(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType2 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType2 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType2.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType2.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType2.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType1 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType1(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType2 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType3 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType2(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType3 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType3 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType2{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType2) {
        OfType2 that = (OfType2) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType2> {
      final OfType3.Mapper ofType3FieldMapper = new OfType3.Mapper();

      @Override
      public OfType2 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType3 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType3>() {
          @Override
          public OfType3 read(ResponseReader reader) {
            return ofType3FieldMapper.map(reader);
          }
        });
        return new OfType2(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType3 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType3 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType3.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType3.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType3.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType2 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType2(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType3 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType3(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType3{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType3) {
        OfType3 that = (OfType3) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType3> {
      @Override
      public OfType3 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        return new OfType3(__typename, kind, name);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public OfType3 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType3(__typename, kind, name);
      }
    }
  }

  public static class Type1 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forFragment("__typename", "__typename", Arrays.asList("__Type"))
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType4 ofType;

    private final @Nonnull Fragments fragments;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Type1(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType4 ofType, @Nonnull Fragments fragments) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
      this.fragments = Utils.checkNotNull(fragments, "fragments == null");
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType4 ofType() {
      return this.ofType;
    }

    public @Nonnull Fragments fragments() {
      return this.fragments;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
          fragments.marshaller().marshal(writer);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Type1{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType + ", "
          + "fragments=" + fragments
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Type1) {
        Type1 that = (Type1) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType))
         && this.fragments.equals(that.fragments);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        h *= 1000003;
        h ^= fragments.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      builder.fragments = fragments;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static class Fragments {
      final @Nonnull TypeRef typeRef;

      private volatile String $toString;

      private volatile int $hashCode;

      private volatile boolean $hashCodeMemoized;

      public Fragments(@Nonnull TypeRef typeRef) {
        this.typeRef = Utils.checkNotNull(typeRef, "typeRef == null");
      }

      public @Nonnull TypeRef typeRef() {
        return this.typeRef;
      }

      public ResponseFieldMarshaller marshaller() {
        return new ResponseFieldMarshaller() {
          @Override
          public void marshal(ResponseWriter writer) {
            final TypeRef $typeRef = typeRef;
            if ($typeRef != null) {
              $typeRef.marshaller().marshal(writer);
            }
          }
        };
      }

      @Override
      public String toString() {
        if ($toString == null) {
          $toString = "Fragments{"
            + "typeRef=" + typeRef
            + "}";
        }
        return $toString;
      }

      @Override
      public boolean equals(Object o) {
        if (o == this) {
          return true;
        }
        if (o instanceof Fragments) {
          Fragments that = (Fragments) o;
          return this.typeRef.equals(that.typeRef);
        }
        return false;
      }

      @Override
      public int hashCode() {
        if (!$hashCodeMemoized) {
          int h = 1;
          h *= 1000003;
          h ^= typeRef.hashCode();
          $hashCode = h;
          $hashCodeMemoized = true;
        }
        return $hashCode;
      }

      public Builder toBuilder() {
        Builder builder = new Builder();
        builder.typeRef = typeRef;
        return builder;
      }

      public static Builder builder() {
        return new Builder();
      }

      public static final class Mapper implements FragmentResponseFieldMapper<Fragments> {
        final TypeRef.Mapper typeRefFieldMapper = new TypeRef.Mapper();

        @Override
        public @Nonnull Fragments map(ResponseReader reader, @Nonnull String conditionalType) {
          TypeRef typeRef = null;
          if (TypeRef.POSSIBLE_TYPES.contains(conditionalType)) {
            typeRef = typeRefFieldMapper.map(reader);
          }
          return new Fragments(Utils.checkNotNull(typeRef, "typeRef == null"));
        }
      }

      public static final class Builder {
        private @Nonnull TypeRef typeRef;

        Builder() {
        }

        public Builder typeRef(@Nonnull TypeRef typeRef) {
          this.typeRef = typeRef;
          return this;
        }

        public Fragments build() {
          Utils.checkNotNull(typeRef, "typeRef == null");
          return new Fragments(typeRef);
        }
      }
    }

    public static final class Mapper implements ResponseFieldMapper<Type1> {
      final OfType4.Mapper ofType4FieldMapper = new OfType4.Mapper();

      final Fragments.Mapper fragmentsFieldMapper = new Fragments.Mapper();

      @Override
      public Type1 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType4 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType4>() {
          @Override
          public OfType4 read(ResponseReader reader) {
            return ofType4FieldMapper.map(reader);
          }
        });
        final Fragments fragments = reader.readConditional($responseFields[4], new ResponseReader.ConditionalTypeReader<Fragments>() {
          @Override
          public Fragments read(String conditionalType, ResponseReader reader) {
            return fragmentsFieldMapper.map(reader, conditionalType);
          }
        });
        return new Type1(__typename, kind, name, ofType, fragments);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType4 ofType;

      private @Nonnull Fragments fragments;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType4 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder fragments(@Nonnull Fragments fragments) {
        this.fragments = fragments;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType4.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType4.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType4.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public Builder fragments(@Nonnull Mutator<Fragments.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Fragments.Builder builder = this.fragments != null ? this.fragments.toBuilder() : Fragments.builder();
        mutator.accept(builder);
        this.fragments = builder.build();
        return this;
      }

      public Type1 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        Utils.checkNotNull(fragments, "fragments == null");
        return new Type1(__typename, kind, name, ofType, fragments);
      }
    }
  }

  public static class OfType4 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType5 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType4(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType5 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType5 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType4{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType4) {
        OfType4 that = (OfType4) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType4> {
      final OfType5.Mapper ofType5FieldMapper = new OfType5.Mapper();

      @Override
      public OfType4 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType5 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType5>() {
          @Override
          public OfType5 read(ResponseReader reader) {
            return ofType5FieldMapper.map(reader);
          }
        });
        return new OfType4(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType5 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType5 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType5.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType5.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType5.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType4 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType4(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType5 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType6 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType5(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType6 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType6 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType5{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType5) {
        OfType5 that = (OfType5) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType5> {
      final OfType6.Mapper ofType6FieldMapper = new OfType6.Mapper();

      @Override
      public OfType5 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType6 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType6>() {
          @Override
          public OfType6 read(ResponseReader reader) {
            return ofType6FieldMapper.map(reader);
          }
        });
        return new OfType5(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType6 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType6 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType6.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType6.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType6.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType5 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType5(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType6 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType7 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType6(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType7 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType7 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType6{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType6) {
        OfType6 that = (OfType6) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType6> {
      final OfType7.Mapper ofType7FieldMapper = new OfType7.Mapper();

      @Override
      public OfType6 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType7 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType7>() {
          @Override
          public OfType7 read(ResponseReader reader) {
            return ofType7FieldMapper.map(reader);
          }
        });
        return new OfType6(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType7 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType7 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType7.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType7.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType7.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType6 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType6(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType7 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType7(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType7{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType7) {
        OfType7 that = (OfType7) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType7> {
      @Override
      public OfType7 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        return new OfType7(__typename, kind, name);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public OfType7 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType7(__typename, kind, name);
      }
    }
  }

  public static class InputField {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("description", "description", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("type", "type", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("defaultValue", "defaultValue", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forFragment("__typename", "__typename", Arrays.asList("__InputValue"))
    };

    final @Nonnull String __typename;

    final @Nonnull String name;

    final @Nullable String description;

    final @Nonnull Type2 type;

    final @Nullable String defaultValue;

    private final @Nonnull Fragments fragments;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public InputField(@Nonnull String __typename, @Nonnull String name,
        @Nullable String description, @Nonnull Type2 type, @Nullable String defaultValue,
        @Nonnull Fragments fragments) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.name = Utils.checkNotNull(name, "name == null");
      this.description = description;
      this.type = Utils.checkNotNull(type, "type == null");
      this.defaultValue = defaultValue;
      this.fragments = Utils.checkNotNull(fragments, "fragments == null");
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull String name() {
      return this.name;
    }

    public @Nullable String description() {
      return this.description;
    }

    public @Nonnull Type2 type() {
      return this.type;
    }

    /**
     * A GraphQL-formatted string representing the default value for this input value.
     */
    public @Nullable String defaultValue() {
      return this.defaultValue;
    }

    public @Nonnull Fragments fragments() {
      return this.fragments;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], name);
          writer.writeString($responseFields[2], description);
          writer.writeObject($responseFields[3], type.marshaller());
          writer.writeString($responseFields[4], defaultValue);
          fragments.marshaller().marshal(writer);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "InputField{"
          + "__typename=" + __typename + ", "
          + "name=" + name + ", "
          + "description=" + description + ", "
          + "type=" + type + ", "
          + "defaultValue=" + defaultValue + ", "
          + "fragments=" + fragments
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof InputField) {
        InputField that = (InputField) o;
        return this.__typename.equals(that.__typename)
         && this.name.equals(that.name)
         && ((this.description == null) ? (that.description == null) : this.description.equals(that.description))
         && this.type.equals(that.type)
         && ((this.defaultValue == null) ? (that.defaultValue == null) : this.defaultValue.equals(that.defaultValue))
         && this.fragments.equals(that.fragments);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= name.hashCode();
        h *= 1000003;
        h ^= (description == null) ? 0 : description.hashCode();
        h *= 1000003;
        h ^= type.hashCode();
        h *= 1000003;
        h ^= (defaultValue == null) ? 0 : defaultValue.hashCode();
        h *= 1000003;
        h ^= fragments.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.name = name;
      builder.description = description;
      builder.type = type;
      builder.defaultValue = defaultValue;
      builder.fragments = fragments;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static class Fragments {
      final @Nonnull InputValue inputValue;

      private volatile String $toString;

      private volatile int $hashCode;

      private volatile boolean $hashCodeMemoized;

      public Fragments(@Nonnull InputValue inputValue) {
        this.inputValue = Utils.checkNotNull(inputValue, "inputValue == null");
      }

      public @Nonnull InputValue inputValue() {
        return this.inputValue;
      }

      public ResponseFieldMarshaller marshaller() {
        return new ResponseFieldMarshaller() {
          @Override
          public void marshal(ResponseWriter writer) {
            final InputValue $inputValue = inputValue;
            if ($inputValue != null) {
              $inputValue.marshaller().marshal(writer);
            }
          }
        };
      }

      @Override
      public String toString() {
        if ($toString == null) {
          $toString = "Fragments{"
            + "inputValue=" + inputValue
            + "}";
        }
        return $toString;
      }

      @Override
      public boolean equals(Object o) {
        if (o == this) {
          return true;
        }
        if (o instanceof Fragments) {
          Fragments that = (Fragments) o;
          return this.inputValue.equals(that.inputValue);
        }
        return false;
      }

      @Override
      public int hashCode() {
        if (!$hashCodeMemoized) {
          int h = 1;
          h *= 1000003;
          h ^= inputValue.hashCode();
          $hashCode = h;
          $hashCodeMemoized = true;
        }
        return $hashCode;
      }

      public Builder toBuilder() {
        Builder builder = new Builder();
        builder.inputValue = inputValue;
        return builder;
      }

      public static Builder builder() {
        return new Builder();
      }

      public static final class Mapper implements FragmentResponseFieldMapper<Fragments> {
        final InputValue.Mapper inputValueFieldMapper = new InputValue.Mapper();

        @Override
        public @Nonnull Fragments map(ResponseReader reader, @Nonnull String conditionalType) {
          InputValue inputValue = null;
          if (InputValue.POSSIBLE_TYPES.contains(conditionalType)) {
            inputValue = inputValueFieldMapper.map(reader);
          }
          return new Fragments(Utils.checkNotNull(inputValue, "inputValue == null"));
        }
      }

      public static final class Builder {
        private @Nonnull InputValue inputValue;

        Builder() {
        }

        public Builder inputValue(@Nonnull InputValue inputValue) {
          this.inputValue = inputValue;
          return this;
        }

        public Fragments build() {
          Utils.checkNotNull(inputValue, "inputValue == null");
          return new Fragments(inputValue);
        }
      }
    }

    public static final class Mapper implements ResponseFieldMapper<InputField> {
      final Type2.Mapper type2FieldMapper = new Type2.Mapper();

      final Fragments.Mapper fragmentsFieldMapper = new Fragments.Mapper();

      @Override
      public InputField map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String name = reader.readString($responseFields[1]);
        final String description = reader.readString($responseFields[2]);
        final Type2 type = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<Type2>() {
          @Override
          public Type2 read(ResponseReader reader) {
            return type2FieldMapper.map(reader);
          }
        });
        final String defaultValue = reader.readString($responseFields[4]);
        final Fragments fragments = reader.readConditional($responseFields[5], new ResponseReader.ConditionalTypeReader<Fragments>() {
          @Override
          public Fragments read(String conditionalType, ResponseReader reader) {
            return fragmentsFieldMapper.map(reader, conditionalType);
          }
        });
        return new InputField(__typename, name, description, type, defaultValue, fragments);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull String name;

      private @Nullable String description;

      private @Nonnull Type2 type;

      private @Nullable String defaultValue;

      private @Nonnull Fragments fragments;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder name(@Nonnull String name) {
        this.name = name;
        return this;
      }

      public Builder description(@Nullable String description) {
        this.description = description;
        return this;
      }

      public Builder type(@Nonnull Type2 type) {
        this.type = type;
        return this;
      }

      public Builder defaultValue(@Nullable String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
      }

      public Builder fragments(@Nonnull Fragments fragments) {
        this.fragments = fragments;
        return this;
      }

      public Builder type(@Nonnull Mutator<Type2.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Type2.Builder builder = this.type != null ? this.type.toBuilder() : Type2.builder();
        mutator.accept(builder);
        this.type = builder.build();
        return this;
      }

      public Builder fragments(@Nonnull Mutator<Fragments.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Fragments.Builder builder = this.fragments != null ? this.fragments.toBuilder() : Fragments.builder();
        mutator.accept(builder);
        this.fragments = builder.build();
        return this;
      }

      public InputField build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(name, "name == null");
        Utils.checkNotNull(type, "type == null");
        Utils.checkNotNull(fragments, "fragments == null");
        return new InputField(__typename, name, description, type, defaultValue, fragments);
      }
    }
  }

  public static class Type2 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forFragment("__typename", "__typename", Arrays.asList("__Type"))
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType8 ofType;

    private final @Nonnull Fragments fragments;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Type2(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType8 ofType, @Nonnull Fragments fragments) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
      this.fragments = Utils.checkNotNull(fragments, "fragments == null");
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType8 ofType() {
      return this.ofType;
    }

    public @Nonnull Fragments fragments() {
      return this.fragments;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
          fragments.marshaller().marshal(writer);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Type2{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType + ", "
          + "fragments=" + fragments
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Type2) {
        Type2 that = (Type2) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType))
         && this.fragments.equals(that.fragments);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        h *= 1000003;
        h ^= fragments.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      builder.fragments = fragments;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static class Fragments {
      final @Nonnull TypeRef typeRef;

      private volatile String $toString;

      private volatile int $hashCode;

      private volatile boolean $hashCodeMemoized;

      public Fragments(@Nonnull TypeRef typeRef) {
        this.typeRef = Utils.checkNotNull(typeRef, "typeRef == null");
      }

      public @Nonnull TypeRef typeRef() {
        return this.typeRef;
      }

      public ResponseFieldMarshaller marshaller() {
        return new ResponseFieldMarshaller() {
          @Override
          public void marshal(ResponseWriter writer) {
            final TypeRef $typeRef = typeRef;
            if ($typeRef != null) {
              $typeRef.marshaller().marshal(writer);
            }
          }
        };
      }

      @Override
      public String toString() {
        if ($toString == null) {
          $toString = "Fragments{"
            + "typeRef=" + typeRef
            + "}";
        }
        return $toString;
      }

      @Override
      public boolean equals(Object o) {
        if (o == this) {
          return true;
        }
        if (o instanceof Fragments) {
          Fragments that = (Fragments) o;
          return this.typeRef.equals(that.typeRef);
        }
        return false;
      }

      @Override
      public int hashCode() {
        if (!$hashCodeMemoized) {
          int h = 1;
          h *= 1000003;
          h ^= typeRef.hashCode();
          $hashCode = h;
          $hashCodeMemoized = true;
        }
        return $hashCode;
      }

      public Builder toBuilder() {
        Builder builder = new Builder();
        builder.typeRef = typeRef;
        return builder;
      }

      public static Builder builder() {
        return new Builder();
      }

      public static final class Mapper implements FragmentResponseFieldMapper<Fragments> {
        final TypeRef.Mapper typeRefFieldMapper = new TypeRef.Mapper();

        @Override
        public @Nonnull Fragments map(ResponseReader reader, @Nonnull String conditionalType) {
          TypeRef typeRef = null;
          if (TypeRef.POSSIBLE_TYPES.contains(conditionalType)) {
            typeRef = typeRefFieldMapper.map(reader);
          }
          return new Fragments(Utils.checkNotNull(typeRef, "typeRef == null"));
        }
      }

      public static final class Builder {
        private @Nonnull TypeRef typeRef;

        Builder() {
        }

        public Builder typeRef(@Nonnull TypeRef typeRef) {
          this.typeRef = typeRef;
          return this;
        }

        public Fragments build() {
          Utils.checkNotNull(typeRef, "typeRef == null");
          return new Fragments(typeRef);
        }
      }
    }

    public static final class Mapper implements ResponseFieldMapper<Type2> {
      final OfType8.Mapper ofType8FieldMapper = new OfType8.Mapper();

      final Fragments.Mapper fragmentsFieldMapper = new Fragments.Mapper();

      @Override
      public Type2 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType8 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType8>() {
          @Override
          public OfType8 read(ResponseReader reader) {
            return ofType8FieldMapper.map(reader);
          }
        });
        final Fragments fragments = reader.readConditional($responseFields[4], new ResponseReader.ConditionalTypeReader<Fragments>() {
          @Override
          public Fragments read(String conditionalType, ResponseReader reader) {
            return fragmentsFieldMapper.map(reader, conditionalType);
          }
        });
        return new Type2(__typename, kind, name, ofType, fragments);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType8 ofType;

      private @Nonnull Fragments fragments;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType8 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder fragments(@Nonnull Fragments fragments) {
        this.fragments = fragments;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType8.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType8.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType8.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public Builder fragments(@Nonnull Mutator<Fragments.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Fragments.Builder builder = this.fragments != null ? this.fragments.toBuilder() : Fragments.builder();
        mutator.accept(builder);
        this.fragments = builder.build();
        return this;
      }

      public Type2 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        Utils.checkNotNull(fragments, "fragments == null");
        return new Type2(__typename, kind, name, ofType, fragments);
      }
    }
  }

  public static class OfType8 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType9 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType8(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType9 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType9 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType8{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType8) {
        OfType8 that = (OfType8) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType8> {
      final OfType9.Mapper ofType9FieldMapper = new OfType9.Mapper();

      @Override
      public OfType8 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType9 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType9>() {
          @Override
          public OfType9 read(ResponseReader reader) {
            return ofType9FieldMapper.map(reader);
          }
        });
        return new OfType8(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType9 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType9 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType9.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType9.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType9.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType8 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType8(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType9 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType10 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType9(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType10 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType10 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType9{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType9) {
        OfType9 that = (OfType9) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType9> {
      final OfType10.Mapper ofType10FieldMapper = new OfType10.Mapper();

      @Override
      public OfType9 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType10 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType10>() {
          @Override
          public OfType10 read(ResponseReader reader) {
            return ofType10FieldMapper.map(reader);
          }
        });
        return new OfType9(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType10 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType10 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType10.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType10.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType10.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType9 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType9(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType10 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType11 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType10(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType11 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType11 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType10{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType10) {
        OfType10 that = (OfType10) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType10> {
      final OfType11.Mapper ofType11FieldMapper = new OfType11.Mapper();

      @Override
      public OfType10 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType11 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType11>() {
          @Override
          public OfType11 read(ResponseReader reader) {
            return ofType11FieldMapper.map(reader);
          }
        });
        return new OfType10(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType11 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType11 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType11.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType11.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType11.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType10 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType10(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType11 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType11(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType11{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType11) {
        OfType11 that = (OfType11) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType11> {
      @Override
      public OfType11 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        return new OfType11(__typename, kind, name);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public OfType11 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType11(__typename, kind, name);
      }
    }
  }

  public static class Interface {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forFragment("__typename", "__typename", Arrays.asList("__Type"))
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType12 ofType;

    private final @Nonnull Fragments fragments;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Interface(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType12 ofType, @Nonnull Fragments fragments) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
      this.fragments = Utils.checkNotNull(fragments, "fragments == null");
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType12 ofType() {
      return this.ofType;
    }

    public @Nonnull Fragments fragments() {
      return this.fragments;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
          fragments.marshaller().marshal(writer);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Interface{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType + ", "
          + "fragments=" + fragments
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Interface) {
        Interface that = (Interface) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType))
         && this.fragments.equals(that.fragments);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        h *= 1000003;
        h ^= fragments.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      builder.fragments = fragments;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static class Fragments {
      final @Nonnull TypeRef typeRef;

      private volatile String $toString;

      private volatile int $hashCode;

      private volatile boolean $hashCodeMemoized;

      public Fragments(@Nonnull TypeRef typeRef) {
        this.typeRef = Utils.checkNotNull(typeRef, "typeRef == null");
      }

      public @Nonnull TypeRef typeRef() {
        return this.typeRef;
      }

      public ResponseFieldMarshaller marshaller() {
        return new ResponseFieldMarshaller() {
          @Override
          public void marshal(ResponseWriter writer) {
            final TypeRef $typeRef = typeRef;
            if ($typeRef != null) {
              $typeRef.marshaller().marshal(writer);
            }
          }
        };
      }

      @Override
      public String toString() {
        if ($toString == null) {
          $toString = "Fragments{"
            + "typeRef=" + typeRef
            + "}";
        }
        return $toString;
      }

      @Override
      public boolean equals(Object o) {
        if (o == this) {
          return true;
        }
        if (o instanceof Fragments) {
          Fragments that = (Fragments) o;
          return this.typeRef.equals(that.typeRef);
        }
        return false;
      }

      @Override
      public int hashCode() {
        if (!$hashCodeMemoized) {
          int h = 1;
          h *= 1000003;
          h ^= typeRef.hashCode();
          $hashCode = h;
          $hashCodeMemoized = true;
        }
        return $hashCode;
      }

      public Builder toBuilder() {
        Builder builder = new Builder();
        builder.typeRef = typeRef;
        return builder;
      }

      public static Builder builder() {
        return new Builder();
      }

      public static final class Mapper implements FragmentResponseFieldMapper<Fragments> {
        final TypeRef.Mapper typeRefFieldMapper = new TypeRef.Mapper();

        @Override
        public @Nonnull Fragments map(ResponseReader reader, @Nonnull String conditionalType) {
          TypeRef typeRef = null;
          if (TypeRef.POSSIBLE_TYPES.contains(conditionalType)) {
            typeRef = typeRefFieldMapper.map(reader);
          }
          return new Fragments(Utils.checkNotNull(typeRef, "typeRef == null"));
        }
      }

      public static final class Builder {
        private @Nonnull TypeRef typeRef;

        Builder() {
        }

        public Builder typeRef(@Nonnull TypeRef typeRef) {
          this.typeRef = typeRef;
          return this;
        }

        public Fragments build() {
          Utils.checkNotNull(typeRef, "typeRef == null");
          return new Fragments(typeRef);
        }
      }
    }

    public static final class Mapper implements ResponseFieldMapper<Interface> {
      final OfType12.Mapper ofType12FieldMapper = new OfType12.Mapper();

      final Fragments.Mapper fragmentsFieldMapper = new Fragments.Mapper();

      @Override
      public Interface map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType12 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType12>() {
          @Override
          public OfType12 read(ResponseReader reader) {
            return ofType12FieldMapper.map(reader);
          }
        });
        final Fragments fragments = reader.readConditional($responseFields[4], new ResponseReader.ConditionalTypeReader<Fragments>() {
          @Override
          public Fragments read(String conditionalType, ResponseReader reader) {
            return fragmentsFieldMapper.map(reader, conditionalType);
          }
        });
        return new Interface(__typename, kind, name, ofType, fragments);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType12 ofType;

      private @Nonnull Fragments fragments;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType12 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder fragments(@Nonnull Fragments fragments) {
        this.fragments = fragments;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType12.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType12.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType12.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public Builder fragments(@Nonnull Mutator<Fragments.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Fragments.Builder builder = this.fragments != null ? this.fragments.toBuilder() : Fragments.builder();
        mutator.accept(builder);
        this.fragments = builder.build();
        return this;
      }

      public Interface build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        Utils.checkNotNull(fragments, "fragments == null");
        return new Interface(__typename, kind, name, ofType, fragments);
      }
    }
  }

  public static class OfType12 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType13 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType12(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType13 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType13 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType12{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType12) {
        OfType12 that = (OfType12) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType12> {
      final OfType13.Mapper ofType13FieldMapper = new OfType13.Mapper();

      @Override
      public OfType12 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType13 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType13>() {
          @Override
          public OfType13 read(ResponseReader reader) {
            return ofType13FieldMapper.map(reader);
          }
        });
        return new OfType12(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType13 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType13 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType13.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType13.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType13.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType12 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType12(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType13 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType14 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType13(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType14 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType14 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType13{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType13) {
        OfType13 that = (OfType13) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType13> {
      final OfType14.Mapper ofType14FieldMapper = new OfType14.Mapper();

      @Override
      public OfType13 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType14 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType14>() {
          @Override
          public OfType14 read(ResponseReader reader) {
            return ofType14FieldMapper.map(reader);
          }
        });
        return new OfType13(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType14 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType14 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType14.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType14.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType14.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType13 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType13(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType14 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType15 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType14(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType15 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType15 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType14{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType14) {
        OfType14 that = (OfType14) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType14> {
      final OfType15.Mapper ofType15FieldMapper = new OfType15.Mapper();

      @Override
      public OfType14 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType15 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType15>() {
          @Override
          public OfType15 read(ResponseReader reader) {
            return ofType15FieldMapper.map(reader);
          }
        });
        return new OfType14(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType15 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType15 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType15.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType15.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType15.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType14 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType14(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType15 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType15(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType15{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType15) {
        OfType15 that = (OfType15) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType15> {
      @Override
      public OfType15 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        return new OfType15(__typename, kind, name);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public OfType15 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType15(__typename, kind, name);
      }
    }
  }

  public static class EnumValue {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("description", "description", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forBoolean("isDeprecated", "isDeprecated", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("deprecationReason", "deprecationReason", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull String name;

    final @Nullable String description;

    final boolean isDeprecated;

    final @Nullable String deprecationReason;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public EnumValue(@Nonnull String __typename, @Nonnull String name, @Nullable String description,
        boolean isDeprecated, @Nullable String deprecationReason) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.name = Utils.checkNotNull(name, "name == null");
      this.description = description;
      this.isDeprecated = isDeprecated;
      this.deprecationReason = deprecationReason;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull String name() {
      return this.name;
    }

    public @Nullable String description() {
      return this.description;
    }

    public boolean isDeprecated() {
      return this.isDeprecated;
    }

    public @Nullable String deprecationReason() {
      return this.deprecationReason;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], name);
          writer.writeString($responseFields[2], description);
          writer.writeBoolean($responseFields[3], isDeprecated);
          writer.writeString($responseFields[4], deprecationReason);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "EnumValue{"
          + "__typename=" + __typename + ", "
          + "name=" + name + ", "
          + "description=" + description + ", "
          + "isDeprecated=" + isDeprecated + ", "
          + "deprecationReason=" + deprecationReason
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof EnumValue) {
        EnumValue that = (EnumValue) o;
        return this.__typename.equals(that.__typename)
         && this.name.equals(that.name)
         && ((this.description == null) ? (that.description == null) : this.description.equals(that.description))
         && this.isDeprecated == that.isDeprecated
         && ((this.deprecationReason == null) ? (that.deprecationReason == null) : this.deprecationReason.equals(that.deprecationReason));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= name.hashCode();
        h *= 1000003;
        h ^= (description == null) ? 0 : description.hashCode();
        h *= 1000003;
        h ^= Boolean.valueOf(isDeprecated).hashCode();
        h *= 1000003;
        h ^= (deprecationReason == null) ? 0 : deprecationReason.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.name = name;
      builder.description = description;
      builder.isDeprecated = isDeprecated;
      builder.deprecationReason = deprecationReason;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<EnumValue> {
      @Override
      public EnumValue map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String name = reader.readString($responseFields[1]);
        final String description = reader.readString($responseFields[2]);
        final boolean isDeprecated = reader.readBoolean($responseFields[3]);
        final String deprecationReason = reader.readString($responseFields[4]);
        return new EnumValue(__typename, name, description, isDeprecated, deprecationReason);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull String name;

      private @Nullable String description;

      private boolean isDeprecated;

      private @Nullable String deprecationReason;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder name(@Nonnull String name) {
        this.name = name;
        return this;
      }

      public Builder description(@Nullable String description) {
        this.description = description;
        return this;
      }

      public Builder isDeprecated(boolean isDeprecated) {
        this.isDeprecated = isDeprecated;
        return this;
      }

      public Builder deprecationReason(@Nullable String deprecationReason) {
        this.deprecationReason = deprecationReason;
        return this;
      }

      public EnumValue build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(name, "name == null");
        return new EnumValue(__typename, name, description, isDeprecated, deprecationReason);
      }
    }
  }

  public static class PossibleType {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forFragment("__typename", "__typename", Arrays.asList("__Type"))
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType16 ofType;

    private final @Nonnull Fragments fragments;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public PossibleType(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType16 ofType, @Nonnull Fragments fragments) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
      this.fragments = Utils.checkNotNull(fragments, "fragments == null");
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType16 ofType() {
      return this.ofType;
    }

    public @Nonnull Fragments fragments() {
      return this.fragments;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
          fragments.marshaller().marshal(writer);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "PossibleType{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType + ", "
          + "fragments=" + fragments
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof PossibleType) {
        PossibleType that = (PossibleType) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType))
         && this.fragments.equals(that.fragments);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        h *= 1000003;
        h ^= fragments.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      builder.fragments = fragments;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static class Fragments {
      final @Nonnull TypeRef typeRef;

      private volatile String $toString;

      private volatile int $hashCode;

      private volatile boolean $hashCodeMemoized;

      public Fragments(@Nonnull TypeRef typeRef) {
        this.typeRef = Utils.checkNotNull(typeRef, "typeRef == null");
      }

      public @Nonnull TypeRef typeRef() {
        return this.typeRef;
      }

      public ResponseFieldMarshaller marshaller() {
        return new ResponseFieldMarshaller() {
          @Override
          public void marshal(ResponseWriter writer) {
            final TypeRef $typeRef = typeRef;
            if ($typeRef != null) {
              $typeRef.marshaller().marshal(writer);
            }
          }
        };
      }

      @Override
      public String toString() {
        if ($toString == null) {
          $toString = "Fragments{"
            + "typeRef=" + typeRef
            + "}";
        }
        return $toString;
      }

      @Override
      public boolean equals(Object o) {
        if (o == this) {
          return true;
        }
        if (o instanceof Fragments) {
          Fragments that = (Fragments) o;
          return this.typeRef.equals(that.typeRef);
        }
        return false;
      }

      @Override
      public int hashCode() {
        if (!$hashCodeMemoized) {
          int h = 1;
          h *= 1000003;
          h ^= typeRef.hashCode();
          $hashCode = h;
          $hashCodeMemoized = true;
        }
        return $hashCode;
      }

      public Builder toBuilder() {
        Builder builder = new Builder();
        builder.typeRef = typeRef;
        return builder;
      }

      public static Builder builder() {
        return new Builder();
      }

      public static final class Mapper implements FragmentResponseFieldMapper<Fragments> {
        final TypeRef.Mapper typeRefFieldMapper = new TypeRef.Mapper();

        @Override
        public @Nonnull Fragments map(ResponseReader reader, @Nonnull String conditionalType) {
          TypeRef typeRef = null;
          if (TypeRef.POSSIBLE_TYPES.contains(conditionalType)) {
            typeRef = typeRefFieldMapper.map(reader);
          }
          return new Fragments(Utils.checkNotNull(typeRef, "typeRef == null"));
        }
      }

      public static final class Builder {
        private @Nonnull TypeRef typeRef;

        Builder() {
        }

        public Builder typeRef(@Nonnull TypeRef typeRef) {
          this.typeRef = typeRef;
          return this;
        }

        public Fragments build() {
          Utils.checkNotNull(typeRef, "typeRef == null");
          return new Fragments(typeRef);
        }
      }
    }

    public static final class Mapper implements ResponseFieldMapper<PossibleType> {
      final OfType16.Mapper ofType16FieldMapper = new OfType16.Mapper();

      final Fragments.Mapper fragmentsFieldMapper = new Fragments.Mapper();

      @Override
      public PossibleType map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType16 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType16>() {
          @Override
          public OfType16 read(ResponseReader reader) {
            return ofType16FieldMapper.map(reader);
          }
        });
        final Fragments fragments = reader.readConditional($responseFields[4], new ResponseReader.ConditionalTypeReader<Fragments>() {
          @Override
          public Fragments read(String conditionalType, ResponseReader reader) {
            return fragmentsFieldMapper.map(reader, conditionalType);
          }
        });
        return new PossibleType(__typename, kind, name, ofType, fragments);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType16 ofType;

      private @Nonnull Fragments fragments;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType16 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder fragments(@Nonnull Fragments fragments) {
        this.fragments = fragments;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType16.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType16.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType16.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public Builder fragments(@Nonnull Mutator<Fragments.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Fragments.Builder builder = this.fragments != null ? this.fragments.toBuilder() : Fragments.builder();
        mutator.accept(builder);
        this.fragments = builder.build();
        return this;
      }

      public PossibleType build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        Utils.checkNotNull(fragments, "fragments == null");
        return new PossibleType(__typename, kind, name, ofType, fragments);
      }
    }
  }

  public static class OfType16 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType17 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType16(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType17 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType17 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType16{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType16) {
        OfType16 that = (OfType16) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType16> {
      final OfType17.Mapper ofType17FieldMapper = new OfType17.Mapper();

      @Override
      public OfType16 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType17 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType17>() {
          @Override
          public OfType17 read(ResponseReader reader) {
            return ofType17FieldMapper.map(reader);
          }
        });
        return new OfType16(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType17 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType17 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType17.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType17.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType17.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType16 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType16(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType17 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType18 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType17(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType18 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType18 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType17{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType17) {
        OfType17 that = (OfType17) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType17> {
      final OfType18.Mapper ofType18FieldMapper = new OfType18.Mapper();

      @Override
      public OfType17 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType18 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType18>() {
          @Override
          public OfType18 read(ResponseReader reader) {
            return ofType18FieldMapper.map(reader);
          }
        });
        return new OfType17(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType18 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType18 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType18.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType18.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType18.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType17 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType17(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType18 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("ofType", "ofType", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    final @Nullable OfType19 ofType;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType18(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name,
        @Nullable OfType19 ofType) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
      this.ofType = ofType;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public @Nullable OfType19 ofType() {
      return this.ofType;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
          writer.writeObject($responseFields[3], ofType != null ? ofType.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType18{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name + ", "
          + "ofType=" + ofType
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType18) {
        OfType18 that = (OfType18) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.ofType == null) ? (that.ofType == null) : this.ofType.equals(that.ofType));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (ofType == null) ? 0 : ofType.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      builder.ofType = ofType;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType18> {
      final OfType19.Mapper ofType19FieldMapper = new OfType19.Mapper();

      @Override
      public OfType18 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        final OfType19 ofType = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<OfType19>() {
          @Override
          public OfType19 read(ResponseReader reader) {
            return ofType19FieldMapper.map(reader);
          }
        });
        return new OfType18(__typename, kind, name, ofType);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      private @Nullable OfType19 ofType;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder ofType(@Nullable OfType19 ofType) {
        this.ofType = ofType;
        return this;
      }

      public Builder ofType(@Nonnull Mutator<OfType19.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        OfType19.Builder builder = this.ofType != null ? this.ofType.toBuilder() : OfType19.builder();
        mutator.accept(builder);
        this.ofType = builder.build();
        return this;
      }

      public OfType18 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType18(__typename, kind, name, ofType);
      }
    }
  }

  public static class OfType19 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("kind", "kind", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull __TypeKind kind;

    final @Nullable String name;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public OfType19(@Nonnull String __typename, @Nonnull __TypeKind kind, @Nullable String name) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.kind = Utils.checkNotNull(kind, "kind == null");
      this.name = name;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    public @Nonnull __TypeKind kind() {
      return this.kind;
    }

    public @Nullable String name() {
      return this.name;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], kind.name());
          writer.writeString($responseFields[2], name);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "OfType19{"
          + "__typename=" + __typename + ", "
          + "kind=" + kind + ", "
          + "name=" + name
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof OfType19) {
        OfType19 that = (OfType19) o;
        return this.__typename.equals(that.__typename)
         && this.kind.equals(that.kind)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= kind.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.kind = kind;
      builder.name = name;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<OfType19> {
      @Override
      public OfType19 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String kindStr = reader.readString($responseFields[1]);
        final __TypeKind kind;
        if (kindStr != null) {
          kind = __TypeKind.valueOf(kindStr);
        } else {
          kind = null;
        }
        final String name = reader.readString($responseFields[2]);
        return new OfType19(__typename, kind, name);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull __TypeKind kind;

      private @Nullable String name;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder kind(@Nonnull __TypeKind kind) {
        this.kind = kind;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public OfType19 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(kind, "kind == null");
        return new OfType19(__typename, kind, name);
      }
    }
  }

  public static final class Builder {
    private @Nonnull String __typename;

    private @Nonnull __TypeKind kind;

    private @Nullable String name;

    private @Nullable String description;

    private @Nullable List<Field> fields;

    private @Nullable List<InputField> inputFields;

    private @Nullable List<Interface> interfaces;

    private @Nullable List<EnumValue> enumValues;

    private @Nullable List<PossibleType> possibleTypes;

    Builder() {
    }

    public Builder __typename(@Nonnull String __typename) {
      this.__typename = __typename;
      return this;
    }

    public Builder kind(@Nonnull __TypeKind kind) {
      this.kind = kind;
      return this;
    }

    public Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    public Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    public Builder fields(@Nullable List<Field> fields) {
      this.fields = fields;
      return this;
    }

    public Builder inputFields(@Nullable List<InputField> inputFields) {
      this.inputFields = inputFields;
      return this;
    }

    public Builder interfaces(@Nullable List<Interface> interfaces) {
      this.interfaces = interfaces;
      return this;
    }

    public Builder enumValues(@Nullable List<EnumValue> enumValues) {
      this.enumValues = enumValues;
      return this;
    }

    public Builder possibleTypes(@Nullable List<PossibleType> possibleTypes) {
      this.possibleTypes = possibleTypes;
      return this;
    }

    public Builder fields(@Nonnull Mutator<List<Field.Builder>> mutator) {
      Utils.checkNotNull(mutator, "mutator == null");
      List<Field.Builder> builders = new ArrayList<>();
      if (this.fields != null) {
        for (Field item : this.fields) {
          builders.add(item != null ? item.toBuilder() : null);
        }
      }
      mutator.accept(builders);
      List<Field> fields = new ArrayList<>();
      for (Field.Builder item : builders) {
        fields.add(item != null ? item.build() : null);
      }
      this.fields = fields;
      return this;
    }

    public Builder inputFields(@Nonnull Mutator<List<InputField.Builder>> mutator) {
      Utils.checkNotNull(mutator, "mutator == null");
      List<InputField.Builder> builders = new ArrayList<>();
      if (this.inputFields != null) {
        for (InputField item : this.inputFields) {
          builders.add(item != null ? item.toBuilder() : null);
        }
      }
      mutator.accept(builders);
      List<InputField> inputFields = new ArrayList<>();
      for (InputField.Builder item : builders) {
        inputFields.add(item != null ? item.build() : null);
      }
      this.inputFields = inputFields;
      return this;
    }

    public Builder interfaces(@Nonnull Mutator<List<Interface.Builder>> mutator) {
      Utils.checkNotNull(mutator, "mutator == null");
      List<Interface.Builder> builders = new ArrayList<>();
      if (this.interfaces != null) {
        for (Interface item : this.interfaces) {
          builders.add(item != null ? item.toBuilder() : null);
        }
      }
      mutator.accept(builders);
      List<Interface> interfaces = new ArrayList<>();
      for (Interface.Builder item : builders) {
        interfaces.add(item != null ? item.build() : null);
      }
      this.interfaces = interfaces;
      return this;
    }

    public Builder enumValues(@Nonnull Mutator<List<EnumValue.Builder>> mutator) {
      Utils.checkNotNull(mutator, "mutator == null");
      List<EnumValue.Builder> builders = new ArrayList<>();
      if (this.enumValues != null) {
        for (EnumValue item : this.enumValues) {
          builders.add(item != null ? item.toBuilder() : null);
        }
      }
      mutator.accept(builders);
      List<EnumValue> enumValues = new ArrayList<>();
      for (EnumValue.Builder item : builders) {
        enumValues.add(item != null ? item.build() : null);
      }
      this.enumValues = enumValues;
      return this;
    }

    public Builder possibleTypes(@Nonnull Mutator<List<PossibleType.Builder>> mutator) {
      Utils.checkNotNull(mutator, "mutator == null");
      List<PossibleType.Builder> builders = new ArrayList<>();
      if (this.possibleTypes != null) {
        for (PossibleType item : this.possibleTypes) {
          builders.add(item != null ? item.toBuilder() : null);
        }
      }
      mutator.accept(builders);
      List<PossibleType> possibleTypes = new ArrayList<>();
      for (PossibleType.Builder item : builders) {
        possibleTypes.add(item != null ? item.build() : null);
      }
      this.possibleTypes = possibleTypes;
      return this;
    }

    public FullType build() {
      Utils.checkNotNull(__typename, "__typename == null");
      Utils.checkNotNull(kind, "kind == null");
      return new FullType(__typename, kind, name, description, fields, inputFields, interfaces, enumValues, possibleTypes);
    }
  }
}
