package com.fluentcommerce.graphql.queries.settings;

import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.api.internal.Mutator;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.fluentretail.graphql.type.CustomType;
import java.io.IOException;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Generated("Apollo GraphQL")
public final class GetSettingsQuery implements Query<GetSettingsQuery.Data, GetSettingsQuery.Data, GetSettingsQuery.Variables> {
  public static final String OPERATION_DEFINITION = "query GetSettings($settingsNames: [String!]!, $locationId: Int = -1, $retailerId: Int = -1) {\n"
      + "  location: settings(name: $settingsNames, context: \"AGENT\", contextId: [$locationId], first: 1000) {\n"
      + "    __typename\n"
      + "    edges {\n"
      + "      __typename\n"
      + "      node {\n"
      + "        __typename\n"
      + "        context\n"
      + "        id\n"
      + "        name\n"
      + "        value\n"
      + "        lobValue\n"
      + "      }\n"
      + "    }\n"
      + "  }\n"
      + "  retailer: settings(name: $settingsNames, context: \"RETAILER\", contextId: [$retailerId], first: 1000) {\n"
      + "    __typename\n"
      + "    edges {\n"
      + "      __typename\n"
      + "      node {\n"
      + "        __typename\n"
      + "        context\n"
      + "        id\n"
      + "        name\n"
      + "        value\n"
      + "        lobValue\n"
      + "      }\n"
      + "    }\n"
      + "  }\n"
      + "  account: settings(name: $settingsNames, context: \"ACCOUNT\", first: 1000) {\n"
      + "    __typename\n"
      + "    edges {\n"
      + "      __typename\n"
      + "      node {\n"
      + "        __typename\n"
      + "        context\n"
      + "        id\n"
      + "        name\n"
      + "        value\n"
      + "        lobValue\n"
      + "      }\n"
      + "    }\n"
      + "  }\n"
      + "  global: settings(name: $settingsNames, context: \"GLOBAL\", first: 1000) {\n"
      + "    __typename\n"
      + "    edges {\n"
      + "      __typename\n"
      + "      node {\n"
      + "        __typename\n"
      + "        context\n"
      + "        id\n"
      + "        name\n"
      + "        value\n"
      + "        lobValue\n"
      + "      }\n"
      + "    }\n"
      + "  }\n"
      + "}";

  public static final String QUERY_DOCUMENT = OPERATION_DEFINITION;

  private static final OperationName OPERATION_NAME = new OperationName() {
    @Override
    public String name() {
      return "GetSettings";
    }
  };

  private final GetSettingsQuery.Variables variables;

  public GetSettingsQuery(@Nonnull List<String> settingsNames, @Nullable Integer locationId,
      @Nullable Integer retailerId) {
    Utils.checkNotNull(settingsNames, "settingsNames == null");
    variables = new GetSettingsQuery.Variables(settingsNames, locationId, retailerId);
  }

  @Override
  public String operationId() {
    return "35e293bffaab9a9394e17813b4fcfd31c1de1d8279eb51ae02b68b20c42d7989";
  }

  @Override
  public String queryDocument() {
    return QUERY_DOCUMENT;
  }

  @Override
  public GetSettingsQuery.Data wrapData(GetSettingsQuery.Data data) {
    return data;
  }

  @Override
  public GetSettingsQuery.Variables variables() {
    return variables;
  }

  @Override
  public ResponseFieldMapper<GetSettingsQuery.Data> responseFieldMapper() {
    return new Data.Mapper();
  }

  public static Builder builder() {
    return new Builder();
  }

  @Override
  public OperationName name() {
    return OPERATION_NAME;
  }

  public static final class Builder {
    private @Nonnull List<String> settingsNames;

    private @Nullable Integer locationId;

    private @Nullable Integer retailerId;

    Builder() {
    }

    public Builder settingsNames(@Nonnull List<String> settingsNames) {
      this.settingsNames = settingsNames;
      return this;
    }

    public Builder locationId(@Nullable Integer locationId) {
      this.locationId = locationId;
      return this;
    }

    public Builder retailerId(@Nullable Integer retailerId) {
      this.retailerId = retailerId;
      return this;
    }

    public GetSettingsQuery build() {
      Utils.checkNotNull(settingsNames, "settingsNames == null");
      return new GetSettingsQuery(settingsNames, locationId, retailerId);
    }
  }

  public static final class Variables extends Operation.Variables {
    private final @Nonnull List<String> settingsNames;

    private final @Nullable Integer locationId;

    private final @Nullable Integer retailerId;

    private final transient Map<String, Object> valueMap = new LinkedHashMap<>();

    Variables(@Nonnull List<String> settingsNames, @Nullable Integer locationId,
        @Nullable Integer retailerId) {
      this.settingsNames = settingsNames;
      this.locationId = locationId;
      this.retailerId = retailerId;
      this.valueMap.put("settingsNames", settingsNames);
      this.valueMap.put("locationId", locationId);
      this.valueMap.put("retailerId", retailerId);
    }

    public @Nonnull List<String> settingsNames() {
      return settingsNames;
    }

    public @Nullable Integer locationId() {
      return locationId;
    }

    public @Nullable Integer retailerId() {
      return retailerId;
    }

    @Override
    public Map<String, Object> valueMap() {
      return Collections.unmodifiableMap(valueMap);
    }

    @Override
    public InputFieldMarshaller marshaller() {
      return new InputFieldMarshaller() {
        @Override
        public void marshal(InputFieldWriter writer) throws IOException {
          writer.writeList("settingsNames", new InputFieldWriter.ListWriter() {
            @Override
            public void write(InputFieldWriter.ListItemWriter listItemWriter) throws IOException {
              for (String $item : settingsNames) {
                listItemWriter.writeString($item);
              }
            }
          });
          writer.writeInt("locationId", locationId);
          writer.writeInt("retailerId", retailerId);
        }
      };
    }
  }

  public static class Data implements Operation.Data {
    static final ResponseField[] $responseFields = {
      ResponseField.forObject("location", "settings", new UnmodifiableMapBuilder<String, Object>(4)
        .put("name", new UnmodifiableMapBuilder<String, Object>(2)
          .put("kind", "Variable")
          .put("variableName", "settingsNames")
        .build())
        .put("context", "AGENT")
        .put("contextId", "[{kind=Variable, variableName=locationId}]")
        .put("first", "1000.0")
      .build(), true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("retailer", "settings", new UnmodifiableMapBuilder<String, Object>(4)
        .put("name", new UnmodifiableMapBuilder<String, Object>(2)
          .put("kind", "Variable")
          .put("variableName", "settingsNames")
        .build())
        .put("context", "RETAILER")
        .put("contextId", "[{kind=Variable, variableName=retailerId}]")
        .put("first", "1000.0")
      .build(), true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("account", "settings", new UnmodifiableMapBuilder<String, Object>(3)
        .put("name", new UnmodifiableMapBuilder<String, Object>(2)
          .put("kind", "Variable")
          .put("variableName", "settingsNames")
        .build())
        .put("context", "ACCOUNT")
        .put("first", "1000.0")
      .build(), true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("global", "settings", new UnmodifiableMapBuilder<String, Object>(3)
        .put("name", new UnmodifiableMapBuilder<String, Object>(2)
          .put("kind", "Variable")
          .put("variableName", "settingsNames")
        .build())
        .put("context", "GLOBAL")
        .put("first", "1000.0")
      .build(), true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nullable Location location;

    final @Nullable Retailer retailer;

    final @Nullable Account account;

    final @Nullable Global global;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Data(@Nullable Location location, @Nullable Retailer retailer, @Nullable Account account,
        @Nullable Global global) {
      this.location = location;
      this.retailer = retailer;
      this.account = account;
      this.global = global;
    }

    /**
     *  Search for Setting entities
     */
    public @Nullable Location location() {
      return this.location;
    }

    /**
     *  Search for Setting entities
     */
    public @Nullable Retailer retailer() {
      return this.retailer;
    }

    /**
     *  Search for Setting entities
     */
    public @Nullable Account account() {
      return this.account;
    }

    /**
     *  Search for Setting entities
     */
    public @Nullable Global global() {
      return this.global;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeObject($responseFields[0], location != null ? location.marshaller() : null);
          writer.writeObject($responseFields[1], retailer != null ? retailer.marshaller() : null);
          writer.writeObject($responseFields[2], account != null ? account.marshaller() : null);
          writer.writeObject($responseFields[3], global != null ? global.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Data{"
          + "location=" + location + ", "
          + "retailer=" + retailer + ", "
          + "account=" + account + ", "
          + "global=" + global
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Data) {
        Data that = (Data) o;
        return ((this.location == null) ? (that.location == null) : this.location.equals(that.location))
         && ((this.retailer == null) ? (that.retailer == null) : this.retailer.equals(that.retailer))
         && ((this.account == null) ? (that.account == null) : this.account.equals(that.account))
         && ((this.global == null) ? (that.global == null) : this.global.equals(that.global));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= (location == null) ? 0 : location.hashCode();
        h *= 1000003;
        h ^= (retailer == null) ? 0 : retailer.hashCode();
        h *= 1000003;
        h ^= (account == null) ? 0 : account.hashCode();
        h *= 1000003;
        h ^= (global == null) ? 0 : global.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.location = location;
      builder.retailer = retailer;
      builder.account = account;
      builder.global = global;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Data> {
      final Location.Mapper locationFieldMapper = new Location.Mapper();

      final Retailer.Mapper retailerFieldMapper = new Retailer.Mapper();

      final Account.Mapper accountFieldMapper = new Account.Mapper();

      final Global.Mapper globalFieldMapper = new Global.Mapper();

      @Override
      public Data map(ResponseReader reader) {
        final Location location = reader.readObject($responseFields[0], new ResponseReader.ObjectReader<Location>() {
          @Override
          public Location read(ResponseReader reader) {
            return locationFieldMapper.map(reader);
          }
        });
        final Retailer retailer = reader.readObject($responseFields[1], new ResponseReader.ObjectReader<Retailer>() {
          @Override
          public Retailer read(ResponseReader reader) {
            return retailerFieldMapper.map(reader);
          }
        });
        final Account account = reader.readObject($responseFields[2], new ResponseReader.ObjectReader<Account>() {
          @Override
          public Account read(ResponseReader reader) {
            return accountFieldMapper.map(reader);
          }
        });
        final Global global = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<Global>() {
          @Override
          public Global read(ResponseReader reader) {
            return globalFieldMapper.map(reader);
          }
        });
        return new Data(location, retailer, account, global);
      }
    }

    public static final class Builder {
      private @Nullable Location location;

      private @Nullable Retailer retailer;

      private @Nullable Account account;

      private @Nullable Global global;

      Builder() {
      }

      public Builder location(@Nullable Location location) {
        this.location = location;
        return this;
      }

      public Builder retailer(@Nullable Retailer retailer) {
        this.retailer = retailer;
        return this;
      }

      public Builder account(@Nullable Account account) {
        this.account = account;
        return this;
      }

      public Builder global(@Nullable Global global) {
        this.global = global;
        return this;
      }

      public Builder location(@Nonnull Mutator<Location.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Location.Builder builder = this.location != null ? this.location.toBuilder() : Location.builder();
        mutator.accept(builder);
        this.location = builder.build();
        return this;
      }

      public Builder retailer(@Nonnull Mutator<Retailer.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Retailer.Builder builder = this.retailer != null ? this.retailer.toBuilder() : Retailer.builder();
        mutator.accept(builder);
        this.retailer = builder.build();
        return this;
      }

      public Builder account(@Nonnull Mutator<Account.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Account.Builder builder = this.account != null ? this.account.toBuilder() : Account.builder();
        mutator.accept(builder);
        this.account = builder.build();
        return this;
      }

      public Builder global(@Nonnull Mutator<Global.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Global.Builder builder = this.global != null ? this.global.toBuilder() : Global.builder();
        mutator.accept(builder);
        this.global = builder.build();
        return this;
      }

      public Data build() {
        return new Data(location, retailer, account, global);
      }
    }
  }

  public static class Location {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forList("edges", "edges", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nullable List<Edge> edges;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Location(@Nonnull String __typename, @Nullable List<Edge> edges) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.edges = edges;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    /**
     *  A list of edges that links to Setting type node
     */
    public @Nullable List<Edge> edges() {
      return this.edges;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeList($responseFields[1], edges, new ResponseWriter.ListWriter() {
            @Override
            public void write(Object value, ResponseWriter.ListItemWriter listItemWriter) {
              listItemWriter.writeObject(((Edge) value).marshaller());
            }
          });
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Location{"
          + "__typename=" + __typename + ", "
          + "edges=" + edges
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Location) {
        Location that = (Location) o;
        return this.__typename.equals(that.__typename)
         && ((this.edges == null) ? (that.edges == null) : this.edges.equals(that.edges));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= (edges == null) ? 0 : edges.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.edges = edges;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Location> {
      final Edge.Mapper edgeFieldMapper = new Edge.Mapper();

      @Override
      public Location map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final List<Edge> edges = reader.readList($responseFields[1], new ResponseReader.ListReader<Edge>() {
          @Override
          public Edge read(ResponseReader.ListItemReader listItemReader) {
            return listItemReader.readObject(new ResponseReader.ObjectReader<Edge>() {
              @Override
              public Edge read(ResponseReader reader) {
                return edgeFieldMapper.map(reader);
              }
            });
          }
        });
        return new Location(__typename, edges);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nullable List<Edge> edges;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder edges(@Nullable List<Edge> edges) {
        this.edges = edges;
        return this;
      }

      public Builder edges(@Nonnull Mutator<List<Edge.Builder>> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        List<Edge.Builder> builders = new ArrayList<>();
        if (this.edges != null) {
          for (Edge item : this.edges) {
            builders.add(item != null ? item.toBuilder() : null);
          }
        }
        mutator.accept(builders);
        List<Edge> edges = new ArrayList<>();
        for (Edge.Builder item : builders) {
          edges.add(item != null ? item.build() : null);
        }
        this.edges = edges;
        return this;
      }

      public Location build() {
        Utils.checkNotNull(__typename, "__typename == null");
        return new Location(__typename, edges);
      }
    }
  }

  public static class Edge {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("node", "node", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nullable Node node;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Edge(@Nonnull String __typename, @Nullable Node node) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.node = node;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    /**
     *  The item at the end of the Setting edge
     */
    public @Nullable Node node() {
      return this.node;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeObject($responseFields[1], node != null ? node.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Edge{"
          + "__typename=" + __typename + ", "
          + "node=" + node
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Edge) {
        Edge that = (Edge) o;
        return this.__typename.equals(that.__typename)
         && ((this.node == null) ? (that.node == null) : this.node.equals(that.node));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= (node == null) ? 0 : node.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.node = node;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Edge> {
      final Node.Mapper nodeFieldMapper = new Node.Mapper();

      @Override
      public Edge map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final Node node = reader.readObject($responseFields[1], new ResponseReader.ObjectReader<Node>() {
          @Override
          public Node read(ResponseReader reader) {
            return nodeFieldMapper.map(reader);
          }
        });
        return new Edge(__typename, node);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nullable Node node;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder node(@Nullable Node node) {
        this.node = node;
        return this;
      }

      public Builder node(@Nonnull Mutator<Node.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Node.Builder builder = this.node != null ? this.node.toBuilder() : Node.builder();
        mutator.accept(builder);
        this.node = builder.build();
        return this;
      }

      public Edge build() {
        Utils.checkNotNull(__typename, "__typename == null");
        return new Edge(__typename, node);
      }
    }
  }

  public static class Node {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("context", "context", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("value", "value", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forCustomType("lobValue", "lobValue", null, true, CustomType.JSON, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull String context;

    final @Nonnull String id;

    final @Nullable String name;

    final @Nullable String value;

    final @Nullable Object lobValue;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Node(@Nonnull String __typename, @Nonnull String context, @Nonnull String id,
        @Nullable String name, @Nullable String value, @Nullable Object lobValue) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.context = Utils.checkNotNull(context, "context == null");
      this.id = Utils.checkNotNull(id, "id == null");
      this.name = name;
      this.value = value;
      this.lobValue = lobValue;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    /**
     *  The context of the setting. Supported values are ACCOUNT, RETAILER, AGENT or CUSTOMER
     */
    public @Nonnull String context() {
      return this.context;
    }

    /**
     *  ID of the object
     */
    public @Nonnull String id() {
      return this.id;
    }

    /**
     *  Name of the setting.
     */
    public @Nullable String name() {
      return this.name;
    }

    /**
     *  Value of the setting. Use this if the value is NOT a JSON.
     */
    public @Nullable String value() {
      return this.value;
    }

    /**
     *  Value of the setting. Use this if the value is a JSON.
     */
    public @Nullable Object lobValue() {
      return this.lobValue;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], context);
          writer.writeCustom((ResponseField.CustomTypeField) $responseFields[2], id);
          writer.writeString($responseFields[3], name);
          writer.writeString($responseFields[4], value);
          writer.writeCustom((ResponseField.CustomTypeField) $responseFields[5], lobValue);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Node{"
          + "__typename=" + __typename + ", "
          + "context=" + context + ", "
          + "id=" + id + ", "
          + "name=" + name + ", "
          + "value=" + value + ", "
          + "lobValue=" + lobValue
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Node) {
        Node that = (Node) o;
        return this.__typename.equals(that.__typename)
         && this.context.equals(that.context)
         && this.id.equals(that.id)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.value == null) ? (that.value == null) : this.value.equals(that.value))
         && ((this.lobValue == null) ? (that.lobValue == null) : this.lobValue.equals(that.lobValue));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= context.hashCode();
        h *= 1000003;
        h ^= id.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (value == null) ? 0 : value.hashCode();
        h *= 1000003;
        h ^= (lobValue == null) ? 0 : lobValue.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.context = context;
      builder.id = id;
      builder.name = name;
      builder.value = value;
      builder.lobValue = lobValue;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Node> {
      @Override
      public Node map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String context = reader.readString($responseFields[1]);
        final String id = reader.readCustomType((ResponseField.CustomTypeField) $responseFields[2]);
        final String name = reader.readString($responseFields[3]);
        final String value = reader.readString($responseFields[4]);
        final Object lobValue = reader.readCustomType((ResponseField.CustomTypeField) $responseFields[5]);
        return new Node(__typename, context, id, name, value, lobValue);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull String context;

      private @Nonnull String id;

      private @Nullable String name;

      private @Nullable String value;

      private @Nullable Object lobValue;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder context(@Nonnull String context) {
        this.context = context;
        return this;
      }

      public Builder id(@Nonnull String id) {
        this.id = id;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder value(@Nullable String value) {
        this.value = value;
        return this;
      }

      public Builder lobValue(@Nullable Object lobValue) {
        this.lobValue = lobValue;
        return this;
      }

      public Node build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(context, "context == null");
        Utils.checkNotNull(id, "id == null");
        return new Node(__typename, context, id, name, value, lobValue);
      }
    }
  }

  public static class Retailer {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forList("edges", "edges", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nullable List<Edge1> edges;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Retailer(@Nonnull String __typename, @Nullable List<Edge1> edges) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.edges = edges;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    /**
     *  A list of edges that links to Setting type node
     */
    public @Nullable List<Edge1> edges() {
      return this.edges;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeList($responseFields[1], edges, new ResponseWriter.ListWriter() {
            @Override
            public void write(Object value, ResponseWriter.ListItemWriter listItemWriter) {
              listItemWriter.writeObject(((Edge1) value).marshaller());
            }
          });
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Retailer{"
          + "__typename=" + __typename + ", "
          + "edges=" + edges
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Retailer) {
        Retailer that = (Retailer) o;
        return this.__typename.equals(that.__typename)
         && ((this.edges == null) ? (that.edges == null) : this.edges.equals(that.edges));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= (edges == null) ? 0 : edges.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.edges = edges;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Retailer> {
      final Edge1.Mapper edge1FieldMapper = new Edge1.Mapper();

      @Override
      public Retailer map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final List<Edge1> edges = reader.readList($responseFields[1], new ResponseReader.ListReader<Edge1>() {
          @Override
          public Edge1 read(ResponseReader.ListItemReader listItemReader) {
            return listItemReader.readObject(new ResponseReader.ObjectReader<Edge1>() {
              @Override
              public Edge1 read(ResponseReader reader) {
                return edge1FieldMapper.map(reader);
              }
            });
          }
        });
        return new Retailer(__typename, edges);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nullable List<Edge1> edges;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder edges(@Nullable List<Edge1> edges) {
        this.edges = edges;
        return this;
      }

      public Builder edges(@Nonnull Mutator<List<Edge1.Builder>> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        List<Edge1.Builder> builders = new ArrayList<>();
        if (this.edges != null) {
          for (Edge1 item : this.edges) {
            builders.add(item != null ? item.toBuilder() : null);
          }
        }
        mutator.accept(builders);
        List<Edge1> edges = new ArrayList<>();
        for (Edge1.Builder item : builders) {
          edges.add(item != null ? item.build() : null);
        }
        this.edges = edges;
        return this;
      }

      public Retailer build() {
        Utils.checkNotNull(__typename, "__typename == null");
        return new Retailer(__typename, edges);
      }
    }
  }

  public static class Edge1 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("node", "node", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nullable Node1 node;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Edge1(@Nonnull String __typename, @Nullable Node1 node) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.node = node;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    /**
     *  The item at the end of the Setting edge
     */
    public @Nullable Node1 node() {
      return this.node;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeObject($responseFields[1], node != null ? node.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Edge1{"
          + "__typename=" + __typename + ", "
          + "node=" + node
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Edge1) {
        Edge1 that = (Edge1) o;
        return this.__typename.equals(that.__typename)
         && ((this.node == null) ? (that.node == null) : this.node.equals(that.node));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= (node == null) ? 0 : node.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.node = node;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Edge1> {
      final Node1.Mapper node1FieldMapper = new Node1.Mapper();

      @Override
      public Edge1 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final Node1 node = reader.readObject($responseFields[1], new ResponseReader.ObjectReader<Node1>() {
          @Override
          public Node1 read(ResponseReader reader) {
            return node1FieldMapper.map(reader);
          }
        });
        return new Edge1(__typename, node);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nullable Node1 node;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder node(@Nullable Node1 node) {
        this.node = node;
        return this;
      }

      public Builder node(@Nonnull Mutator<Node1.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Node1.Builder builder = this.node != null ? this.node.toBuilder() : Node1.builder();
        mutator.accept(builder);
        this.node = builder.build();
        return this;
      }

      public Edge1 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        return new Edge1(__typename, node);
      }
    }
  }

  public static class Node1 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("context", "context", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("value", "value", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forCustomType("lobValue", "lobValue", null, true, CustomType.JSON, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull String context;

    final @Nonnull String id;

    final @Nullable String name;

    final @Nullable String value;

    final @Nullable Object lobValue;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Node1(@Nonnull String __typename, @Nonnull String context, @Nonnull String id,
        @Nullable String name, @Nullable String value, @Nullable Object lobValue) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.context = Utils.checkNotNull(context, "context == null");
      this.id = Utils.checkNotNull(id, "id == null");
      this.name = name;
      this.value = value;
      this.lobValue = lobValue;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    /**
     *  The context of the setting. Supported values are ACCOUNT, RETAILER, AGENT or CUSTOMER
     */
    public @Nonnull String context() {
      return this.context;
    }

    /**
     *  ID of the object
     */
    public @Nonnull String id() {
      return this.id;
    }

    /**
     *  Name of the setting.
     */
    public @Nullable String name() {
      return this.name;
    }

    /**
     *  Value of the setting. Use this if the value is NOT a JSON.
     */
    public @Nullable String value() {
      return this.value;
    }

    /**
     *  Value of the setting. Use this if the value is a JSON.
     */
    public @Nullable Object lobValue() {
      return this.lobValue;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], context);
          writer.writeCustom((ResponseField.CustomTypeField) $responseFields[2], id);
          writer.writeString($responseFields[3], name);
          writer.writeString($responseFields[4], value);
          writer.writeCustom((ResponseField.CustomTypeField) $responseFields[5], lobValue);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Node1{"
          + "__typename=" + __typename + ", "
          + "context=" + context + ", "
          + "id=" + id + ", "
          + "name=" + name + ", "
          + "value=" + value + ", "
          + "lobValue=" + lobValue
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Node1) {
        Node1 that = (Node1) o;
        return this.__typename.equals(that.__typename)
         && this.context.equals(that.context)
         && this.id.equals(that.id)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.value == null) ? (that.value == null) : this.value.equals(that.value))
         && ((this.lobValue == null) ? (that.lobValue == null) : this.lobValue.equals(that.lobValue));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= context.hashCode();
        h *= 1000003;
        h ^= id.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (value == null) ? 0 : value.hashCode();
        h *= 1000003;
        h ^= (lobValue == null) ? 0 : lobValue.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.context = context;
      builder.id = id;
      builder.name = name;
      builder.value = value;
      builder.lobValue = lobValue;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Node1> {
      @Override
      public Node1 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String context = reader.readString($responseFields[1]);
        final String id = reader.readCustomType((ResponseField.CustomTypeField) $responseFields[2]);
        final String name = reader.readString($responseFields[3]);
        final String value = reader.readString($responseFields[4]);
        final Object lobValue = reader.readCustomType((ResponseField.CustomTypeField) $responseFields[5]);
        return new Node1(__typename, context, id, name, value, lobValue);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull String context;

      private @Nonnull String id;

      private @Nullable String name;

      private @Nullable String value;

      private @Nullable Object lobValue;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder context(@Nonnull String context) {
        this.context = context;
        return this;
      }

      public Builder id(@Nonnull String id) {
        this.id = id;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder value(@Nullable String value) {
        this.value = value;
        return this;
      }

      public Builder lobValue(@Nullable Object lobValue) {
        this.lobValue = lobValue;
        return this;
      }

      public Node1 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(context, "context == null");
        Utils.checkNotNull(id, "id == null");
        return new Node1(__typename, context, id, name, value, lobValue);
      }
    }
  }

  public static class Account {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forList("edges", "edges", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nullable List<Edge2> edges;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Account(@Nonnull String __typename, @Nullable List<Edge2> edges) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.edges = edges;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    /**
     *  A list of edges that links to Setting type node
     */
    public @Nullable List<Edge2> edges() {
      return this.edges;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeList($responseFields[1], edges, new ResponseWriter.ListWriter() {
            @Override
            public void write(Object value, ResponseWriter.ListItemWriter listItemWriter) {
              listItemWriter.writeObject(((Edge2) value).marshaller());
            }
          });
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Account{"
          + "__typename=" + __typename + ", "
          + "edges=" + edges
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Account) {
        Account that = (Account) o;
        return this.__typename.equals(that.__typename)
         && ((this.edges == null) ? (that.edges == null) : this.edges.equals(that.edges));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= (edges == null) ? 0 : edges.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.edges = edges;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Account> {
      final Edge2.Mapper edge2FieldMapper = new Edge2.Mapper();

      @Override
      public Account map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final List<Edge2> edges = reader.readList($responseFields[1], new ResponseReader.ListReader<Edge2>() {
          @Override
          public Edge2 read(ResponseReader.ListItemReader listItemReader) {
            return listItemReader.readObject(new ResponseReader.ObjectReader<Edge2>() {
              @Override
              public Edge2 read(ResponseReader reader) {
                return edge2FieldMapper.map(reader);
              }
            });
          }
        });
        return new Account(__typename, edges);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nullable List<Edge2> edges;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder edges(@Nullable List<Edge2> edges) {
        this.edges = edges;
        return this;
      }

      public Builder edges(@Nonnull Mutator<List<Edge2.Builder>> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        List<Edge2.Builder> builders = new ArrayList<>();
        if (this.edges != null) {
          for (Edge2 item : this.edges) {
            builders.add(item != null ? item.toBuilder() : null);
          }
        }
        mutator.accept(builders);
        List<Edge2> edges = new ArrayList<>();
        for (Edge2.Builder item : builders) {
          edges.add(item != null ? item.build() : null);
        }
        this.edges = edges;
        return this;
      }

      public Account build() {
        Utils.checkNotNull(__typename, "__typename == null");
        return new Account(__typename, edges);
      }
    }
  }

  public static class Edge2 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("node", "node", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nullable Node2 node;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Edge2(@Nonnull String __typename, @Nullable Node2 node) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.node = node;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    /**
     *  The item at the end of the Setting edge
     */
    public @Nullable Node2 node() {
      return this.node;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeObject($responseFields[1], node != null ? node.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Edge2{"
          + "__typename=" + __typename + ", "
          + "node=" + node
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Edge2) {
        Edge2 that = (Edge2) o;
        return this.__typename.equals(that.__typename)
         && ((this.node == null) ? (that.node == null) : this.node.equals(that.node));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= (node == null) ? 0 : node.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.node = node;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Edge2> {
      final Node2.Mapper node2FieldMapper = new Node2.Mapper();

      @Override
      public Edge2 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final Node2 node = reader.readObject($responseFields[1], new ResponseReader.ObjectReader<Node2>() {
          @Override
          public Node2 read(ResponseReader reader) {
            return node2FieldMapper.map(reader);
          }
        });
        return new Edge2(__typename, node);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nullable Node2 node;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder node(@Nullable Node2 node) {
        this.node = node;
        return this;
      }

      public Builder node(@Nonnull Mutator<Node2.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Node2.Builder builder = this.node != null ? this.node.toBuilder() : Node2.builder();
        mutator.accept(builder);
        this.node = builder.build();
        return this;
      }

      public Edge2 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        return new Edge2(__typename, node);
      }
    }
  }

  public static class Node2 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("context", "context", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("value", "value", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forCustomType("lobValue", "lobValue", null, true, CustomType.JSON, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull String context;

    final @Nonnull String id;

    final @Nullable String name;

    final @Nullable String value;

    final @Nullable Object lobValue;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Node2(@Nonnull String __typename, @Nonnull String context, @Nonnull String id,
        @Nullable String name, @Nullable String value, @Nullable Object lobValue) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.context = Utils.checkNotNull(context, "context == null");
      this.id = Utils.checkNotNull(id, "id == null");
      this.name = name;
      this.value = value;
      this.lobValue = lobValue;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    /**
     *  The context of the setting. Supported values are ACCOUNT, RETAILER, AGENT or CUSTOMER
     */
    public @Nonnull String context() {
      return this.context;
    }

    /**
     *  ID of the object
     */
    public @Nonnull String id() {
      return this.id;
    }

    /**
     *  Name of the setting.
     */
    public @Nullable String name() {
      return this.name;
    }

    /**
     *  Value of the setting. Use this if the value is NOT a JSON.
     */
    public @Nullable String value() {
      return this.value;
    }

    /**
     *  Value of the setting. Use this if the value is a JSON.
     */
    public @Nullable Object lobValue() {
      return this.lobValue;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], context);
          writer.writeCustom((ResponseField.CustomTypeField) $responseFields[2], id);
          writer.writeString($responseFields[3], name);
          writer.writeString($responseFields[4], value);
          writer.writeCustom((ResponseField.CustomTypeField) $responseFields[5], lobValue);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Node2{"
          + "__typename=" + __typename + ", "
          + "context=" + context + ", "
          + "id=" + id + ", "
          + "name=" + name + ", "
          + "value=" + value + ", "
          + "lobValue=" + lobValue
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Node2) {
        Node2 that = (Node2) o;
        return this.__typename.equals(that.__typename)
         && this.context.equals(that.context)
         && this.id.equals(that.id)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.value == null) ? (that.value == null) : this.value.equals(that.value))
         && ((this.lobValue == null) ? (that.lobValue == null) : this.lobValue.equals(that.lobValue));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= context.hashCode();
        h *= 1000003;
        h ^= id.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (value == null) ? 0 : value.hashCode();
        h *= 1000003;
        h ^= (lobValue == null) ? 0 : lobValue.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.context = context;
      builder.id = id;
      builder.name = name;
      builder.value = value;
      builder.lobValue = lobValue;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Node2> {
      @Override
      public Node2 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String context = reader.readString($responseFields[1]);
        final String id = reader.readCustomType((ResponseField.CustomTypeField) $responseFields[2]);
        final String name = reader.readString($responseFields[3]);
        final String value = reader.readString($responseFields[4]);
        final Object lobValue = reader.readCustomType((ResponseField.CustomTypeField) $responseFields[5]);
        return new Node2(__typename, context, id, name, value, lobValue);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull String context;

      private @Nonnull String id;

      private @Nullable String name;

      private @Nullable String value;

      private @Nullable Object lobValue;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder context(@Nonnull String context) {
        this.context = context;
        return this;
      }

      public Builder id(@Nonnull String id) {
        this.id = id;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder value(@Nullable String value) {
        this.value = value;
        return this;
      }

      public Builder lobValue(@Nullable Object lobValue) {
        this.lobValue = lobValue;
        return this;
      }

      public Node2 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(context, "context == null");
        Utils.checkNotNull(id, "id == null");
        return new Node2(__typename, context, id, name, value, lobValue);
      }
    }
  }

  public static class Global {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forList("edges", "edges", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nullable List<Edge3> edges;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Global(@Nonnull String __typename, @Nullable List<Edge3> edges) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.edges = edges;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    /**
     *  A list of edges that links to Setting type node
     */
    public @Nullable List<Edge3> edges() {
      return this.edges;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeList($responseFields[1], edges, new ResponseWriter.ListWriter() {
            @Override
            public void write(Object value, ResponseWriter.ListItemWriter listItemWriter) {
              listItemWriter.writeObject(((Edge3) value).marshaller());
            }
          });
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Global{"
          + "__typename=" + __typename + ", "
          + "edges=" + edges
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Global) {
        Global that = (Global) o;
        return this.__typename.equals(that.__typename)
         && ((this.edges == null) ? (that.edges == null) : this.edges.equals(that.edges));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= (edges == null) ? 0 : edges.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.edges = edges;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Global> {
      final Edge3.Mapper edge3FieldMapper = new Edge3.Mapper();

      @Override
      public Global map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final List<Edge3> edges = reader.readList($responseFields[1], new ResponseReader.ListReader<Edge3>() {
          @Override
          public Edge3 read(ResponseReader.ListItemReader listItemReader) {
            return listItemReader.readObject(new ResponseReader.ObjectReader<Edge3>() {
              @Override
              public Edge3 read(ResponseReader reader) {
                return edge3FieldMapper.map(reader);
              }
            });
          }
        });
        return new Global(__typename, edges);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nullable List<Edge3> edges;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder edges(@Nullable List<Edge3> edges) {
        this.edges = edges;
        return this;
      }

      public Builder edges(@Nonnull Mutator<List<Edge3.Builder>> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        List<Edge3.Builder> builders = new ArrayList<>();
        if (this.edges != null) {
          for (Edge3 item : this.edges) {
            builders.add(item != null ? item.toBuilder() : null);
          }
        }
        mutator.accept(builders);
        List<Edge3> edges = new ArrayList<>();
        for (Edge3.Builder item : builders) {
          edges.add(item != null ? item.build() : null);
        }
        this.edges = edges;
        return this;
      }

      public Global build() {
        Utils.checkNotNull(__typename, "__typename == null");
        return new Global(__typename, edges);
      }
    }
  }

  public static class Edge3 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forObject("node", "node", null, true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nullable Node3 node;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Edge3(@Nonnull String __typename, @Nullable Node3 node) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.node = node;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    /**
     *  The item at the end of the Setting edge
     */
    public @Nullable Node3 node() {
      return this.node;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeObject($responseFields[1], node != null ? node.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Edge3{"
          + "__typename=" + __typename + ", "
          + "node=" + node
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Edge3) {
        Edge3 that = (Edge3) o;
        return this.__typename.equals(that.__typename)
         && ((this.node == null) ? (that.node == null) : this.node.equals(that.node));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= (node == null) ? 0 : node.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.node = node;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Edge3> {
      final Node3.Mapper node3FieldMapper = new Node3.Mapper();

      @Override
      public Edge3 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final Node3 node = reader.readObject($responseFields[1], new ResponseReader.ObjectReader<Node3>() {
          @Override
          public Node3 read(ResponseReader reader) {
            return node3FieldMapper.map(reader);
          }
        });
        return new Edge3(__typename, node);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nullable Node3 node;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder node(@Nullable Node3 node) {
        this.node = node;
        return this;
      }

      public Builder node(@Nonnull Mutator<Node3.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        Node3.Builder builder = this.node != null ? this.node.toBuilder() : Node3.builder();
        mutator.accept(builder);
        this.node = builder.build();
        return this;
      }

      public Edge3 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        return new Edge3(__typename, node);
      }
    }
  }

  public static class Node3 {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("context", "context", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("name", "name", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forString("value", "value", null, true, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forCustomType("lobValue", "lobValue", null, true, CustomType.JSON, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull String context;

    final @Nonnull String id;

    final @Nullable String name;

    final @Nullable String value;

    final @Nullable Object lobValue;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Node3(@Nonnull String __typename, @Nonnull String context, @Nonnull String id,
        @Nullable String name, @Nullable String value, @Nullable Object lobValue) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.context = Utils.checkNotNull(context, "context == null");
      this.id = Utils.checkNotNull(id, "id == null");
      this.name = name;
      this.value = value;
      this.lobValue = lobValue;
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    /**
     *  The context of the setting. Supported values are ACCOUNT, RETAILER, AGENT or CUSTOMER
     */
    public @Nonnull String context() {
      return this.context;
    }

    /**
     *  ID of the object
     */
    public @Nonnull String id() {
      return this.id;
    }

    /**
     *  Name of the setting.
     */
    public @Nullable String name() {
      return this.name;
    }

    /**
     *  Value of the setting. Use this if the value is NOT a JSON.
     */
    public @Nullable String value() {
      return this.value;
    }

    /**
     *  Value of the setting. Use this if the value is a JSON.
     */
    public @Nullable Object lobValue() {
      return this.lobValue;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeString($responseFields[1], context);
          writer.writeCustom((ResponseField.CustomTypeField) $responseFields[2], id);
          writer.writeString($responseFields[3], name);
          writer.writeString($responseFields[4], value);
          writer.writeCustom((ResponseField.CustomTypeField) $responseFields[5], lobValue);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Node3{"
          + "__typename=" + __typename + ", "
          + "context=" + context + ", "
          + "id=" + id + ", "
          + "name=" + name + ", "
          + "value=" + value + ", "
          + "lobValue=" + lobValue
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Node3) {
        Node3 that = (Node3) o;
        return this.__typename.equals(that.__typename)
         && this.context.equals(that.context)
         && this.id.equals(that.id)
         && ((this.name == null) ? (that.name == null) : this.name.equals(that.name))
         && ((this.value == null) ? (that.value == null) : this.value.equals(that.value))
         && ((this.lobValue == null) ? (that.lobValue == null) : this.lobValue.equals(that.lobValue));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= context.hashCode();
        h *= 1000003;
        h ^= id.hashCode();
        h *= 1000003;
        h ^= (name == null) ? 0 : name.hashCode();
        h *= 1000003;
        h ^= (value == null) ? 0 : value.hashCode();
        h *= 1000003;
        h ^= (lobValue == null) ? 0 : lobValue.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.context = context;
      builder.id = id;
      builder.name = name;
      builder.value = value;
      builder.lobValue = lobValue;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Node3> {
      @Override
      public Node3 map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String context = reader.readString($responseFields[1]);
        final String id = reader.readCustomType((ResponseField.CustomTypeField) $responseFields[2]);
        final String name = reader.readString($responseFields[3]);
        final String value = reader.readString($responseFields[4]);
        final Object lobValue = reader.readCustomType((ResponseField.CustomTypeField) $responseFields[5]);
        return new Node3(__typename, context, id, name, value, lobValue);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull String context;

      private @Nonnull String id;

      private @Nullable String name;

      private @Nullable String value;

      private @Nullable Object lobValue;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder context(@Nonnull String context) {
        this.context = context;
        return this;
      }

      public Builder id(@Nonnull String id) {
        this.id = id;
        return this;
      }

      public Builder name(@Nullable String name) {
        this.name = name;
        return this;
      }

      public Builder value(@Nullable String value) {
        this.value = value;
        return this;
      }

      public Builder lobValue(@Nullable Object lobValue) {
        this.lobValue = lobValue;
        return this;
      }

      public Node3 build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(context, "context == null");
        Utils.checkNotNull(id, "id == null");
        return new Node3(__typename, context, id, name, value, lobValue);
      }
    }
  }
}
